/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.gobblin.data.management.copy.replication.CopyRoute;
import org.apache.gobblin.data.management.copy.replication.CopyRouteGeneratorBase;
import org.apache.gobblin.data.management.copy.replication.DataFlowTopology;
import org.apache.gobblin.data.management.copy.replication.EndPoint;
import org.apache.gobblin.data.management.copy.replication.ReplicationConfiguration;
import org.apache.gobblin.data.management.copy.replication.ReplicationCopyMode;

public class CopyRouteGeneratorOptimizer
extends CopyRouteGeneratorBase {
    @Override
    public Optional<CopyRoute> getPullRoute(ReplicationConfiguration rc, EndPoint copyTo) {
        if (rc.getCopyMode() == ReplicationCopyMode.PUSH) {
            return Optional.absent();
        }
        DataFlowTopology topology = rc.getDataFlowToplogy();
        List<DataFlowTopology.DataFlowPath> paths = topology.getDataFlowPaths();
        for (DataFlowTopology.DataFlowPath p : paths) {
            List<CopyRoute> routes = p.getCopyRoutes();
            if (routes.isEmpty() || !routes.get(0).getCopyTo().equals(copyTo)) continue;
            return this.getOptimizedCopyRoute(routes);
        }
        return Optional.absent();
    }

    public Optional<CopyRoute> getOptimizedCopyRoute(List<CopyRoute> routes) {
        return Optional.absent();
    }
}

