/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.extractor;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.FileAwareInputStream;
import org.apache.gobblin.data.management.copy.splitter.DistcpFileSplitter;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.io.EmptyInputStream;
import org.apache.gobblin.util.io.MeteredInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;

public class FileAwareInputStreamExtractor
implements Extractor<String, FileAwareInputStream> {
    private final FileSystem fs;
    private final CopyableFile file;
    private final WorkUnitState state;
    private boolean recordRead;

    public FileAwareInputStreamExtractor(FileSystem fs, CopyableFile file, WorkUnitState state) {
        this.fs = fs;
        this.file = file;
        this.state = state;
        this.recordRead = false;
    }

    public FileAwareInputStreamExtractor(FileSystem fs, CopyableFile file) {
        this(fs, file, null);
    }

    public String getSchema() throws IOException {
        return FileAwareInputStream.class.getName();
    }

    public FileAwareInputStream readRecord(@Deprecated FileAwareInputStream reuse) throws DataRecordException, IOException {
        if (!this.recordRead) {
            Configuration conf = this.state == null ? HadoopUtils.newConfiguration() : HadoopUtils.getConfFromState((State)this.state);
            FileSystem fsFromFile = this.file.getOrigin().getPath().getFileSystem(conf);
            this.recordRead = true;
            FileAwareInputStream.FileAwareInputStreamBuilder builder = FileAwareInputStream.builder().file(this.file);
            if (this.file.getFileStatus().isDirectory()) {
                return builder.inputStream(EmptyInputStream.instance).build();
            }
            FSDataInputStream dataInputStream = fsFromFile.open(this.file.getFileStatus().getPath());
            if (this.state != null && DistcpFileSplitter.isSplitWorkUnit((State)this.state)) {
                Optional<DistcpFileSplitter.Split> split = DistcpFileSplitter.getSplit((State)this.state);
                builder.split(split);
                if (split.isPresent()) {
                    dataInputStream.seek(((DistcpFileSplitter.Split)split.get()).getLowPosition());
                }
            }
            builder.inputStream((InputStream)MeteredInputStream.builder().in((InputStream)dataInputStream).build());
            return builder.build();
        }
        return null;
    }

    public long getExpectedRecordCount() {
        return 1L;
    }

    public long getHighWatermark() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

