/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.converter;

import com.google.common.base.Function;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.FileAwareInputStream;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.Path;

public abstract class DistcpConverter
extends Converter<String, String, FileAwareInputStream, FileAwareInputStream> {
    public Converter<String, String, FileAwareInputStream, FileAwareInputStream> init(WorkUnitState workUnit) {
        return super.init(workUnit);
    }

    public abstract Function<InputStream, InputStream> inputStreamTransformation();

    public List<String> extensionsToRemove() {
        return new ArrayList<String>();
    }

    public List<String> extensionsToAdd() {
        return new ArrayList<String>();
    }

    public String convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }

    public Iterable<FileAwareInputStream> convertRecord(String outputSchema, FileAwareInputStream fileAwareInputStream, WorkUnitState workUnit) throws DataConversionException {
        this.modifyExtensionAtDestination(fileAwareInputStream.getFile());
        try {
            InputStream newInputStream = (InputStream)this.inputStreamTransformation().apply((Object)fileAwareInputStream.getInputStream());
            return new SingleRecordIterable((Object)fileAwareInputStream.toBuilder().inputStream(newInputStream).build());
        }
        catch (RuntimeException re) {
            throw new DataConversionException((Throwable)re);
        }
    }

    private void modifyExtensionAtDestination(CopyableFile file) {
        if (this.extensionsToRemove().size() > 0) {
            file.setDestination(PathUtils.removeExtension((Path)file.getDestination(), (String[])this.extensionsToRemove().toArray(new String[0])));
        }
    }
}

