/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.gobblin.data.management.dataset.DatasetUtils;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.filters.AndPathFilter;
import org.apache.gobblin.util.filters.HiddenFilter;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class RecursivePathFinder {
    private final Path rootPath;
    private final FileSystem fs;
    private final PathFilter pathFilter;
    private final boolean includeEmptyDirectories;

    public RecursivePathFinder(FileSystem fs, Path rootPath, Properties properties) {
        this.rootPath = PathUtils.getPathWithoutSchemeAndAuthority((Path)rootPath);
        this.fs = fs;
        this.pathFilter = DatasetUtils.instantiatePathFilter(properties);
        this.includeEmptyDirectories = Boolean.parseBoolean(properties.getProperty("gobblin.copy.includeEmptyDirectories"));
    }

    public Set<FileStatus> getPaths(boolean skipHiddenPaths) throws IOException {
        if (!this.fs.exists(this.rootPath)) {
            return Sets.newHashSet();
        }
        AndPathFilter actualFilter = skipHiddenPaths ? new AndPathFilter(new PathFilter[]{new HiddenFilter(), this.pathFilter}) : this.pathFilter;
        List files = FileListUtils.listFilesToCopyAtPath((FileSystem)this.fs, (Path)this.rootPath, (PathFilter)actualFilter, (boolean)this.includeEmptyDirectories);
        return Sets.newHashSet((Iterable)files);
    }
}

