/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.copy.CopySource;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.FileAwareInputStream;
import org.apache.gobblin.data.management.copy.extractor.CloseableFsFileAwareInputStreamExtractor;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableFsCopySource
extends CopySource {
    private static final Logger log = LoggerFactory.getLogger(CloseableFsCopySource.class);
    private final Closer closer = Closer.create();

    @Override
    protected FileSystem getSourceFileSystem(State state) throws IOException {
        return (FileSystem)this.closer.register((Closeable)HadoopUtils.getSourceFileSystem((State)state));
    }

    @Override
    public void shutdown(SourceState state) {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            log.warn("Failed to close all closeables", (Throwable)e);
        }
    }

    @Override
    protected Extractor<String, FileAwareInputStream> extractorForCopyableFile(FileSystem fs, CopyableFile cf, WorkUnitState state) throws IOException {
        return new CloseableFsFileAwareInputStreamExtractor(fs, cf, state);
    }
}

