/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.materializer;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHivePublishEntity;
import org.apache.gobblin.data.management.conversion.hive.materializer.HiveMaterializerQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.query.HiveAvroORCQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.data.management.copy.hive.HiveDatasetFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBasedMaterializerQueryGenerator
extends HiveMaterializerQueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryBasedMaterializerQueryGenerator.class);
    private final String sourceQuery;
    private final HiveConverterUtils.StorageFormat storageFormat;

    public QueryBasedMaterializerQueryGenerator(WorkUnitState workUnitState) throws IOException {
        super(workUnitState);
        this.sourceQuery = workUnitState.getProp("internal.hiveMaterializer.queryResultToMaterialize");
        this.storageFormat = HiveConverterUtils.StorageFormat.valueOf(workUnitState.getProp("internal.hiveMaterializer.storageFormat"));
    }

    @Override
    public List<String> generateQueries() {
        this.ensureParentOfStagingPathExists();
        return Lists.newArrayList((Object[])new String[]{HiveConverterUtils.generateStagingCTASStatement(new HiveDatasetFinder.DbAndTable(this.outputDatabaseName, this.stagingTableName), this.sourceQuery, this.storageFormat, this.stagingDataLocation)});
    }

    @Override
    public QueryBasedHivePublishEntity generatePublishQueries() throws DataConversionException {
        QueryBasedHivePublishEntity publishEntity = new QueryBasedHivePublishEntity();
        List<String> publishQueries = publishEntity.getPublishQueries();
        Map<String, String> publishDirectories = publishEntity.getPublishDirectories();
        List<String> cleanupQueries = publishEntity.getCleanupQueries();
        List<String> cleanupDirectories = publishEntity.getCleanupDirectories();
        String createFinalTableDDL = HiveConverterUtils.generateCreateDuplicateTableDDL(this.outputDatabaseName, this.stagingTableName, this.outputTableName, this.outputDataLocation, (Optional<String>)Optional.of((Object)this.outputDatabaseName));
        publishQueries.add(createFinalTableDDL);
        log.debug("Create final table DDL:\n" + createFinalTableDDL);
        log.debug("Snapshot directory to move: " + this.stagingDataLocation + " to: " + this.outputDataLocation);
        publishDirectories.put(this.stagingDataLocation, this.outputDataLocation);
        String dropStagingTableDDL = HiveAvroORCQueryGenerator.generateDropTableDDL(this.outputDatabaseName, this.stagingTableName);
        log.debug("Drop staging table DDL: " + dropStagingTableDDL);
        cleanupQueries.add(dropStagingTableDDL);
        log.debug("Staging table directory to delete: " + this.stagingDataLocation);
        cleanupDirectories.add(this.stagingDataLocation);
        publishQueries.addAll(HiveAvroORCQueryGenerator.generateDropPartitionsDDL(this.outputDatabaseName, this.outputTableName, new HashMap<String, String>()));
        log.info("Publish partition entity: " + publishEntity);
        return publishEntity;
    }
}

