/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.materializer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.conversion.hive.events.EventWorkunitUtils;
import org.apache.gobblin.data.management.conversion.hive.materializer.HiveMaterializerFromEntityQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTableQueryGenerator
extends HiveMaterializerFromEntityQueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(CopyTableQueryGenerator.class);

    public CopyTableQueryGenerator(WorkUnitState workUnitState) throws IOException {
        super(workUnitState, true);
    }

    @Override
    public List<String> generateQueries() {
        this.ensureParentOfStagingPathExists();
        ArrayList hiveQueries = Lists.newArrayList();
        hiveQueries.add("SET hive.exec.dynamic.partition.mode=nonstrict");
        Preconditions.checkNotNull((Object)((Object)this.workUnit), (Object)"Workunit must not be null");
        EventWorkunitUtils.setBeginDDLBuildTimeMetadata((State)this.workUnit, System.currentTimeMillis());
        HiveConverterUtils.createStagingDirectory(this.fs, this.outputTableMetadata.getDestinationDataPath(), this.conversionEntity, this.workUnitState);
        String createStagingTableDDL = HiveConverterUtils.generateCreateDuplicateTableDDL(this.inputDbName, this.inputTableName, this.stagingTableName, this.stagingDataLocation, (Optional<String>)Optional.of((Object)this.outputDatabaseName));
        hiveQueries.add(createStagingTableDDL);
        log.debug("Create staging table DDL:\n" + createStagingTableDDL);
        String insertInStagingTableDML = HiveConverterUtils.generateTableCopy(this.inputTableName, this.stagingTableName, this.conversionEntity.getTable().getDbName(), this.outputDatabaseName, (Optional<Map<String, String>>)Optional.of((Object)this.partitionsDMLInfo));
        hiveQueries.add(insertInStagingTableDML);
        log.debug("Conversion staging DML: " + insertInStagingTableDML);
        log.info("Conversion Queries {}\n", (Object)hiveQueries);
        EventWorkunitUtils.setEndDDLBuildTimeMetadata((State)this.workUnit, System.currentTimeMillis());
        return hiveQueries;
    }
}

