/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.test;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.retention.profile.MultiCleanableDatasetFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class RetentionTestHelper {
    public static void clean(FileSystem fs, Path retentionConfigClasspathResource, Optional<Path> additionalJobPropsClasspathResource, Path testNameTempPath) throws Exception {
        Properties additionalJobProps = new Properties();
        if (additionalJobPropsClasspathResource.isPresent()) {
            try (InputStream stream = RetentionTestHelper.class.getClassLoader().getResourceAsStream(((Path)additionalJobPropsClasspathResource.get()).toString());){
                additionalJobProps.load(stream);
            }
        }
        if (retentionConfigClasspathResource.getName().endsWith(".job")) {
            Properties jobProps = new Properties();
            InputStream stream = RetentionTestHelper.class.getClassLoader().getResourceAsStream(retentionConfigClasspathResource.toString());
            Object object = null;
            try {
                jobProps.load(stream);
                for (Map.Entry<Object, Object> entry : jobProps.entrySet()) {
                    jobProps.put(entry.getKey(), StringUtils.replace((String)((String)entry.getValue()), (String)"${testNameTempPath}", (String)testNameTempPath.toString()));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            MultiCleanableDatasetFinder finder = new MultiCleanableDatasetFinder(fs, jobProps);
            for (Dataset dataset : finder.findDatasets()) {
                ((CleanableDataset)dataset).clean();
            }
        } else {
            Config testConfig = ConfigFactory.parseResources((String)retentionConfigClasspathResource.toString()).withFallback((ConfigMergeable)ConfigFactory.parseMap((Map)ImmutableMap.of((Object)"testNameTempPath", (Object)PathUtils.getPathWithoutSchemeAndAuthority((Path)testNameTempPath).toString()))).resolve();
            ConfigClient client = (ConfigClient)Mockito.mock(ConfigClient.class);
            Mockito.when((Object)client.getConfig((String)Matchers.any(String.class))).thenReturn((Object)testConfig);
            Properties jobProps = new Properties();
            jobProps.setProperty("gobblin.retention.skip.trash", Boolean.toString(true));
            jobProps.setProperty("gobblin.config.management.store.uri", "dummy");
            jobProps.setProperty("gobblin.config.management.store.enabled", "true");
            jobProps.putAll((Map<?, ?>)additionalJobProps);
            DatasetsFinder finder = (DatasetsFinder)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(testConfig.getString("gobblin.retention.dataset.finder.class")), (List[])new List[]{ImmutableList.of((Object)fs, (Object)jobProps, (Object)testConfig, (Object)client), ImmutableList.of((Object)fs, (Object)jobProps, (Object)client)});
            for (CleanableDataset dataset : finder.findDatasets()) {
                dataset.clean();
            }
        }
    }

    public static void clean(FileSystem fs, Path retentionConfigClasspathResource, Path testNameTempPath) throws Exception {
        RetentionTestHelper.clean(fs, retentionConfigClasspathResource, (Optional<Path>)Optional.absent(), testNameTempPath);
    }
}

