/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.trash.ProxiedTrash;
import org.apache.gobblin.data.management.trash.Trash;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockTrash
extends ProxiedTrash {
    private static final Logger LOG = LoggerFactory.getLogger(MockTrash.class);

    public MockTrash(FileSystem fs, Properties props, String user) throws IOException {
        super(fs, props, user);
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        LOG.info("Simulating move to trash: " + path);
        return true;
    }

    @Override
    public void createTrashSnapshot() throws IOException {
        throw new UnsupportedOperationException("Not supported for " + MockTrash.class);
    }

    @Override
    public void purgeTrashSnapshots() throws IOException {
        throw new UnsupportedOperationException("Not supported for " + MockTrash.class);
    }

    @Override
    protected Path createTrashLocation(FileSystem fs, Properties props, String user) throws IOException {
        return super.createTrashLocation(fs, props, user);
    }

    @Override
    protected List<String> getAllUsersWithTrash() throws IOException {
        return Lists.newArrayList();
    }

    @Override
    protected void ensureTrashLocationExists(FileSystem fs, Path trashLocation) throws IOException {
    }

    @Override
    protected Trash getUserTrash(String user) throws IOException {
        return this;
    }
}

