/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableDataset;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.OwnerAndPermission;
import org.apache.gobblin.data.management.dataset.DatasetUtils;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsetFilesCopyableDataset
implements CopyableDataset,
FileSystemDataset {
    private static final Logger log = LoggerFactory.getLogger(SubsetFilesCopyableDataset.class);
    private final Path rootPath;
    private final FileSystem fs;
    private final List<FileStatus> files;
    private final String identifier;
    private final Properties props;
    private EventSubmitter eventSubmitter;
    private SourceState state;

    public SubsetFilesCopyableDataset(FileSystem fs, Path rootPath, Properties properties, String idenifier, List<FileStatus> subFiles) {
        this.rootPath = PathUtils.getPathWithoutSchemeAndAuthority((Path)rootPath);
        this.fs = fs;
        this.files = subFiles;
        this.identifier = idenifier;
        this.props = properties;
    }

    public SubsetFilesCopyableDataset(FileSystem fs, Path rootPath, Properties properties, String idenifier, List<FileStatus> subFiles, EventSubmitter eventSubmitter) {
        this(fs, rootPath, properties, idenifier, subFiles);
        this.eventSubmitter = eventSubmitter;
    }

    public SubsetFilesCopyableDataset(FileSystem fs, Path rootPath, Properties properties, String idenifier, List<FileStatus> subFiles, EventSubmitter eventSubmitter, SourceState state) {
        this(fs, rootPath, properties, idenifier, subFiles, eventSubmitter);
        this.state = state;
    }

    public String datasetURN() {
        return (this.rootPath + this.identifier).replace('/', '_');
    }

    @Override
    public Collection<? extends CopyEntity> getCopyableFiles(FileSystem targetFs, CopyConfiguration configuration) throws IOException {
        ArrayList copyableFiles = Lists.newArrayList();
        for (FileStatus fileStatus : this.files) {
            if (!this.shouldAddToCopyableFiles(fileStatus)) continue;
            log.debug("Adding copyable file " + fileStatus.getPath() + "for " + this.identifier + " in " + this.rootPath);
            Path targetPath = this.getTargetPath(configuration.getPublishDir(), fileStatus.getPath(), this.identifier);
            copyableFiles.add(CopyableFile.fromOriginAndDestination(this.fs, fileStatus, targetPath, configuration).destinationOwnerAndPermission(this.getDestinationOwnerAndPermission()).fileSet(this.fileSet(fileStatus)).build());
        }
        return DatasetUtils.instantiateCopyableFileFilter(this.props, this.state, this).filter(this.fs, targetFs, copyableFiles);
    }

    public Path getTargetPath(Path publishDir, Path originPath, String identifier) {
        Path filePathRelativeToSearchPath = PathUtils.relativizePath((Path)originPath, (Path)this.rootPath);
        return new Path(publishDir, filePathRelativeToSearchPath);
    }

    public OwnerAndPermission getDestinationOwnerAndPermission() {
        return null;
    }

    public boolean shouldAddToCopyableFiles(FileStatus fileStatus) {
        return true;
    }

    public String fileSet(FileStatus fileStatus) {
        return this.identifier;
    }

    public Path datasetRoot() {
        return this.rootPath;
    }
}

