/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.writer;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHiveConversionEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.SchemaAwareHivePartition;
import org.apache.gobblin.data.management.conversion.hive.events.EventWorkunitUtils;
import org.apache.gobblin.util.HiveJdbcConnector;
import org.apache.gobblin.writer.DataWriter;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveQueryExecutionWriter
implements DataWriter<QueryBasedHiveConversionEntity> {
    private static final Logger log = LoggerFactory.getLogger(HiveQueryExecutionWriter.class);
    private final HiveJdbcConnector hiveJdbcConnector;
    private final State workUnit;
    private static final String AT_CHAR = "@";

    public void write(QueryBasedHiveConversionEntity hiveConversionEntity) throws IOException {
        List<String> conversionQueries = null;
        try {
            conversionQueries = hiveConversionEntity.getQueries();
            EventWorkunitUtils.setBeginConversionDDLExecuteTimeMetadata(this.workUnit, System.currentTimeMillis());
            this.hiveJdbcConnector.executeStatements(conversionQueries.toArray(new String[conversionQueries.size()]));
            this.addPropsForPublisher(hiveConversionEntity);
            EventWorkunitUtils.setEndConversionDDLExecuteTimeMetadata(this.workUnit, System.currentTimeMillis());
        }
        catch (SQLException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Failed to execute queries for %s: ", hiveConversionEntity.getPartition().isPresent() ? ((Partition)hiveConversionEntity.getPartition().get()).getCompleteName() : hiveConversionEntity.getTable().getCompleteName()));
            for (String conversionQuery : conversionQueries) {
                sb.append("\nConversion query attempted by Hive Query writer: ");
                sb.append(conversionQuery);
            }
            String message = sb.toString();
            log.warn(message);
            throw new IOException(message, e);
        }
    }

    private void addPropsForPublisher(QueryBasedHiveConversionEntity hiveConversionEntity) {
        if (!hiveConversionEntity.getPartition().isPresent()) {
            return;
        }
        ConvertibleHiveDataset convertibleHiveDataset = hiveConversionEntity.getConvertibleHiveDataset();
        for (String format : convertibleHiveDataset.getDestFormats()) {
            Optional<ConvertibleHiveDataset.ConversionConfig> conversionConfigForFormat = convertibleHiveDataset.getConversionConfigForFormat(format);
            if (!conversionConfigForFormat.isPresent()) continue;
            SchemaAwareHivePartition sourcePartition = (SchemaAwareHivePartition)((Object)hiveConversionEntity.getHivePartition().get());
            String completeSourcePartitionName = StringUtils.join(Arrays.asList(sourcePartition.getTable().getDbName(), sourcePartition.getTable().getTableName(), sourcePartition.getName()), (String)AT_CHAR);
            ConvertibleHiveDataset.ConversionConfig config = (ConvertibleHiveDataset.ConversionConfig)conversionConfigForFormat.get();
            String completeDestPartitionName = StringUtils.join(Arrays.asList(config.getDestinationDbName(), config.getDestinationTableName(), sourcePartition.getName()), (String)AT_CHAR);
            this.workUnit.setProp("completeSourcePartitionName", (Object)completeSourcePartitionName);
            this.workUnit.setProp("completeDestPartitionName", (Object)completeDestPartitionName);
        }
    }

    public void commit() throws IOException {
    }

    public void close() throws IOException {
        this.hiveJdbcConnector.close();
    }

    public void cleanup() throws IOException {
    }

    public long recordsWritten() {
        return 0L;
    }

    public long bytesWritten() throws IOException {
        return 0L;
    }

    @ConstructorProperties(value={"hiveJdbcConnector", "workUnit"})
    public HiveQueryExecutionWriter(HiveJdbcConnector hiveJdbcConnector, State workUnit) {
        this.hiveJdbcConnector = hiveJdbcConnector;
        this.workUnit = workUnit;
    }
}

