/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.hadoop.fs.Path;

public class StringDatasetVersion
implements FileSystemDatasetVersion {
    protected final String version;
    protected final Path path;

    public StringDatasetVersion(String version, Path path) {
        this.version = version;
        this.path = path;
    }

    @Override
    public int compareTo(FileSystemDatasetVersion other) {
        StringDatasetVersion otherAsString = (StringDatasetVersion)other;
        return this.version.equals(otherAsString.version) ? this.path.compareTo((Object)otherAsString.path) : this.version.compareTo(otherAsString.version);
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.compareTo((StringDatasetVersion)obj) == 0;
    }

    public int hashCode() {
        return this.path.hashCode() + this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }

    @Override
    public Set<Path> getPaths() {
        return Sets.newHashSet((Object[])new Path[]{this.path});
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public Path getPath() {
        return this.path;
    }
}

