/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.data.management.retention.dataset.CleanableDatasetBase;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.retention.policy.TimeBasedRetentionPolicy;
import org.apache.gobblin.data.management.retention.version.finder.DateTimeDatasetVersionFinder;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingDataset
extends CleanableDatasetBase<TimestampedDatasetVersion> {
    private final VersionFinder<? extends TimestampedDatasetVersion> versionFinder;
    private final RetentionPolicy<TimestampedDatasetVersion> retentionPolicy;
    private final Path datasetRoot;

    public TrackingDataset(FileSystem fs, Properties props, Path datasetRoot) throws IOException {
        this(fs, props, datasetRoot, LoggerFactory.getLogger(TrackingDataset.class));
    }

    public TrackingDataset(FileSystem fs, Properties props, Path datasetRoot, Logger log) throws IOException {
        super(fs, props, log);
        this.datasetRoot = datasetRoot;
        this.versionFinder = new DateTimeDatasetVersionFinder(fs, props);
        this.retentionPolicy = new TimeBasedRetentionPolicy(props);
    }

    @Override
    public VersionFinder<? extends TimestampedDatasetVersion> getVersionFinder() {
        return this.versionFinder;
    }

    @Override
    public RetentionPolicy<TimestampedDatasetVersion> getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public Path datasetRoot() {
        return this.datasetRoot;
    }
}

