/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.policy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;

public class CombineSelectionPolicy
implements VersionSelectionPolicy<DatasetVersion> {
    public static final String VERSION_SELECTION_POLICIES_PREFIX = "selection.combine.policy.classes";
    public static final String VERSION_SELECTION_COMBINE_OPERATION = "selection.combine.operation";
    private final List<VersionSelectionPolicy<DatasetVersion>> selectionPolicies;
    private final CombineOperation combineOperation;

    public CombineSelectionPolicy(Config config) throws IOException {
        this(config, new Properties());
    }

    public CombineSelectionPolicy(List<VersionSelectionPolicy<DatasetVersion>> selectionPolicies, CombineOperation combineOperation) {
        this.combineOperation = combineOperation;
        this.selectionPolicies = selectionPolicies;
    }

    public CombineSelectionPolicy(Config config, Properties jobProps) throws IOException {
        Preconditions.checkArgument((boolean)config.hasPath(VERSION_SELECTION_POLICIES_PREFIX), (Object)"Combine operation not specified.");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String combineClassName : config.getStringList(VERSION_SELECTION_POLICIES_PREFIX)) {
            try {
                builder.add((Object)((VersionSelectionPolicy)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(combineClassName), (List[])new List[]{ImmutableList.of((Object)config), ImmutableList.of((Object)jobProps)})));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.selectionPolicies = builder.build();
        if (this.selectionPolicies.size() == 0) {
            throw new IOException("No selection policies specified for " + CombineSelectionPolicy.class.getCanonicalName());
        }
        this.combineOperation = CombineOperation.valueOf(config.getString(VERSION_SELECTION_COMBINE_OPERATION).toUpperCase());
    }

    public CombineSelectionPolicy(Properties props) throws IOException {
        this(ConfigFactory.parseProperties((Properties)props), props);
    }

    @Override
    public Class<? extends DatasetVersion> versionClass() {
        if (this.selectionPolicies.size() == 1) {
            return this.selectionPolicies.get(0).versionClass();
        }
        Class<DatasetVersion> klazz = this.selectionPolicies.get(0).versionClass();
        for (VersionSelectionPolicy<DatasetVersion> policy : this.selectionPolicies) {
            klazz = CombineSelectionPolicy.commonSuperclass(klazz, policy.versionClass());
        }
        return klazz;
    }

    @Override
    public Collection<DatasetVersion> listSelectedVersions(final List<DatasetVersion> allVersions) {
        ArrayList candidateDeletableVersions = Lists.newArrayList((Iterable)Iterables.transform(this.selectionPolicies, (Function)new Function<VersionSelectionPolicy<DatasetVersion>, Set<DatasetVersion>>(){

            @Nullable
            public Set<DatasetVersion> apply(VersionSelectionPolicy<DatasetVersion> input) {
                return Sets.newHashSet(input.listSelectedVersions(allVersions));
            }
        }));
        switch (this.combineOperation) {
            case INTERSECT: {
                return CombineSelectionPolicy.intersectDatasetVersions(candidateDeletableVersions);
            }
            case UNION: {
                return CombineSelectionPolicy.unionDatasetVersions(candidateDeletableVersions);
            }
        }
        throw new RuntimeException("Combine operation " + (Object)((Object)this.combineOperation) + " not recognized.");
    }

    @VisibleForTesting
    public static Class<? extends DatasetVersion> commonSuperclass(Class<? extends DatasetVersion> classA, Class<? extends DatasetVersion> classB) {
        if (classA.isAssignableFrom(classB)) {
            return classA;
        }
        Class<? extends DatasetVersion> klazz = classA;
        while (!klazz.isAssignableFrom(classB)) {
            klazz = klazz.getSuperclass();
        }
        if (DatasetVersion.class.isAssignableFrom(klazz)) {
            return klazz;
        }
        return DatasetVersion.class;
    }

    private static Set<DatasetVersion> intersectDatasetVersions(Collection<Set<DatasetVersion>> sets) {
        if (sets.size() <= 0) {
            return Sets.newHashSet();
        }
        Iterator<Set<DatasetVersion>> it = sets.iterator();
        Sets.SetView outputSet = it.next();
        while (it.hasNext()) {
            outputSet = Sets.intersection(outputSet, it.next());
        }
        return outputSet;
    }

    private static Set<DatasetVersion> unionDatasetVersions(Collection<Set<DatasetVersion>> sets) {
        if (sets.size() <= 0) {
            return Sets.newHashSet();
        }
        Iterator<Set<DatasetVersion>> it = sets.iterator();
        Sets.SetView outputSet = it.next();
        while (it.hasNext()) {
            outputSet = Sets.union(outputSet, it.next());
        }
        return outputSet;
    }

    public String toString() {
        return "CombineSelectionPolicy(selectionPolicies=" + this.selectionPolicies + ", combineOperation=" + (Object)((Object)this.combineOperation) + ")";
    }

    public static enum CombineOperation {
        INTERSECT,
        UNION;

    }
}

