/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPoint;
import org.apache.gobblin.data.management.copy.replication.HadoopFsReplicaConfig;
import org.apache.gobblin.data.management.copy.replication.ReplicationDataValidPathPicker;
import org.apache.gobblin.data.management.copy.replication.WatermarkMetadataUtil;
import org.apache.gobblin.source.extractor.ComparableWatermark;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.util.FileListUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaHadoopFsEndPoint
extends HadoopFsEndPoint {
    private static final Logger log = LoggerFactory.getLogger(ReplicaHadoopFsEndPoint.class);
    public static final String WATERMARK_FILE = "_metadata";
    public static final String LATEST_TIMESTAMP = "latestTimestamp";
    private final HadoopFsReplicaConfig rc;
    private final String replicaName;
    private final Config selectionConfig;
    private boolean watermarkInitialized = false;
    private boolean filesInitialized = false;
    private Optional<ComparableWatermark> cachedWatermark = Optional.absent();
    private Collection<FileStatus> allFileStatus = new ArrayList<FileStatus>();

    public ReplicaHadoopFsEndPoint(HadoopFsReplicaConfig rc, String replicaName, Config selectionConfig) {
        Preconditions.checkArgument((!replicaName.equals("source") ? 1 : 0) != 0, (Object)"replicaName can not be source");
        this.rc = rc;
        this.replicaName = replicaName;
        this.selectionConfig = selectionConfig;
    }

    @Override
    public synchronized Collection<FileStatus> getFiles() throws IOException {
        if (this.filesInitialized) {
            return this.allFileStatus;
        }
        this.filesInitialized = true;
        FileSystem fs = FileSystem.get((URI)this.rc.getFsURI(), (Configuration)new Configuration());
        if (!fs.exists(this.rc.getPath())) {
            return Collections.emptyList();
        }
        Collection<Path> validPaths = ReplicationDataValidPathPicker.getValidPaths(this);
        for (Path p : validPaths) {
            this.allFileStatus.addAll(FileListUtils.listFilesRecursively((FileSystem)fs, (Path)p, (PathFilter)super.getPathFilter(), (boolean)super.isApplyFilterToDirectories()));
        }
        return this.allFileStatus;
    }

    @Override
    public synchronized Optional<ComparableWatermark> getWatermark() {
        if (this.watermarkInitialized) {
            return this.cachedWatermark;
        }
        this.watermarkInitialized = true;
        try {
            Path metaData = new Path(this.rc.getPath(), WATERMARK_FILE);
            FileSystem fs = FileSystem.get((URI)this.rc.getFsURI(), (Configuration)new Configuration());
            if (fs.exists(metaData)) {
                try (FSDataInputStream fin = fs.open(metaData);){
                    InputStreamReader reader = new InputStreamReader((InputStream)fin, Charsets.UTF_8);
                    String content = CharStreams.toString((Readable)reader);
                    Watermark w = WatermarkMetadataUtil.deserialize(content);
                    if (w instanceof ComparableWatermark) {
                        this.cachedWatermark = Optional.of((Object)((ComparableWatermark)w));
                    }
                }
                return this.cachedWatermark;
            }
            return this.cachedWatermark;
        }
        catch (IOException e) {
            log.warn("Can not find _metadata for replica " + this);
            return this.cachedWatermark;
        }
        catch (WatermarkMetadataUtil.WatermarkMetadataMulFormatException e) {
            log.warn("Can not create watermark from _metadata for replica " + this);
            return this.cachedWatermark;
        }
    }

    @Override
    public boolean isSource() {
        return false;
    }

    @Override
    public String getEndPointName() {
        return this.replicaName;
    }

    @Override
    public String getClusterName() {
        return this.rc.getClustername();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("is source", this.isSource()).add("end point name", (Object)this.getEndPointName()).add("hadoopfs config", (Object)this.rc).toString();
    }

    @Override
    public URI getFsURI() {
        return this.rc.getFsURI();
    }

    @Override
    public Path getDatasetPath() {
        return this.rc.getPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rc == null ? 0 : this.rc.hashCode());
        result = 31 * result + (this.replicaName == null ? 0 : this.replicaName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicaHadoopFsEndPoint other = (ReplicaHadoopFsEndPoint)obj;
        if (this.rc == null ? other.rc != null : !this.rc.equals(other.rc)) {
            return false;
        }
        return !(this.replicaName == null ? other.replicaName != null : !this.replicaName.equals(other.replicaName));
    }

    public HadoopFsReplicaConfig getRc() {
        return this.rc;
    }

    public String getReplicaName() {
        return this.replicaName;
    }

    @Override
    public Config getSelectionConfig() {
        return this.selectionConfig;
    }
}

