/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.materializer;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.data.management.conversion.hive.converter.AbstractAvroToOrcConverter;
import org.apache.gobblin.data.management.conversion.hive.entities.HiveProcessingEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHivePublishEntity;
import org.apache.gobblin.data.management.conversion.hive.materializer.HiveMaterializerQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.query.HiveAvroORCQueryGenerator;
import org.apache.gobblin.data.management.conversion.hive.source.HiveWorkUnit;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveDatasetFinder;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveMaterializerFromEntityQueryGenerator
extends HiveMaterializerQueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(HiveMaterializerFromEntityQueryGenerator.class);
    protected final String inputDbName;
    protected final String inputTableName;
    protected final List<String> sourceDataPathIdentifier;
    protected final String stagingDataPartitionDirName;
    protected final String stagingDataPartitionLocation;
    protected final Map<String, String> partitionsDDLInfo;
    protected final Map<String, String> partitionsDMLInfo;
    protected final HiveProcessingEntity conversionEntity;
    protected final Table sourceTable;
    protected final boolean supportTargetPartitioning;

    public HiveMaterializerFromEntityQueryGenerator(WorkUnitState workUnitState, boolean supportTargetPartitioning) throws IOException {
        super(workUnitState);
        try {
            this.conversionEntity = this.getConversionEntity(this.workUnit);
        }
        catch (HiveException | TException ex) {
            throw new IOException(ex);
        }
        this.sourceTable = this.conversionEntity.getTable();
        this.inputDbName = this.sourceTable.getDbName();
        this.inputTableName = this.sourceTable.getTableName();
        this.sourceDataPathIdentifier = this.outputTableMetadata.getSourceDataPathIdentifier();
        this.stagingDataPartitionDirName = HiveConverterUtils.getStagingDataPartitionDirName(this.conversionEntity, this.sourceDataPathIdentifier);
        this.stagingDataPartitionLocation = this.stagingDataLocation + "/" + this.stagingDataPartitionDirName;
        this.partitionsDDLInfo = Maps.newHashMap();
        this.partitionsDMLInfo = Maps.newHashMap();
        HiveConverterUtils.populatePartitionInfo(this.conversionEntity, this.partitionsDDLInfo, this.partitionsDMLInfo);
        this.supportTargetPartitioning = supportTargetPartitioning;
    }

    private HiveProcessingEntity getConversionEntity(HiveWorkUnit hiveWorkUnit) throws IOException, TException, HiveException {
        try (AutoReturnableObject client = this.pool.getClient();){
            HiveDataset dataset = hiveWorkUnit.getHiveDataset();
            HiveDatasetFinder.DbAndTable dbAndTable = dataset.getDbAndTable();
            Table table = new Table(((IMetaStoreClient)client.get()).getTable(dbAndTable.getDb(), dbAndTable.getTable()));
            Partition partition = null;
            if (hiveWorkUnit.getPartitionName().isPresent()) {
                partition = new Partition(table, ((IMetaStoreClient)client.get()).getPartition(dbAndTable.getDb(), dbAndTable.getTable(), (String)hiveWorkUnit.getPartitionName().get()));
            }
            HiveProcessingEntity hiveProcessingEntity = new HiveProcessingEntity(dataset, table, (Optional<Partition>)Optional.fromNullable(partition));
            return hiveProcessingEntity;
        }
    }

    @Override
    public QueryBasedHivePublishEntity generatePublishQueries() throws DataConversionException {
        QueryBasedHivePublishEntity publishEntity = new QueryBasedHivePublishEntity();
        List<String> publishQueries = publishEntity.getPublishQueries();
        Map<String, String> publishDirectories = publishEntity.getPublishDirectories();
        List<String> cleanupQueries = publishEntity.getCleanupQueries();
        List<String> cleanupDirectories = publishEntity.getCleanupDirectories();
        String createFinalTableDDL = HiveConverterUtils.generateCreateDuplicateTableDDL(this.outputDatabaseName, this.stagingTableName, this.outputTableName, this.outputDataLocation, (Optional<String>)Optional.of((Object)this.outputDatabaseName));
        publishQueries.add(createFinalTableDDL);
        log.debug("Create final table DDL:\n" + createFinalTableDDL);
        if (!this.supportTargetPartitioning || this.partitionsDDLInfo.size() == 0) {
            log.debug("Snapshot directory to move: " + this.stagingDataLocation + " to: " + this.outputDataLocation);
            publishDirectories.put(this.stagingDataLocation, this.outputDataLocation);
            String dropStagingTableDDL = HiveAvroORCQueryGenerator.generateDropTableDDL(this.outputDatabaseName, this.stagingTableName);
            log.debug("Drop staging table DDL: " + dropStagingTableDDL);
            cleanupQueries.add(dropStagingTableDDL);
            log.debug("Staging table directory to delete: " + this.stagingDataLocation);
            cleanupDirectories.add(this.stagingDataLocation);
        } else {
            String finalDataPartitionLocation = this.outputDataLocation + "/" + this.stagingDataPartitionDirName;
            Optional<Path> destPartitionLocation = HiveConverterUtils.getDestinationPartitionLocation((Optional<org.apache.hadoop.hive.metastore.api.Table>)this.destinationTableMeta, this.workUnitState, ((Partition)this.conversionEntity.getPartition().get()).getName());
            finalDataPartitionLocation = HiveConverterUtils.updatePartitionLocation(finalDataPartitionLocation, this.workUnitState, destPartitionLocation);
            log.debug("Partition directory to move: " + this.stagingDataPartitionLocation + " to: " + finalDataPartitionLocation);
            publishDirectories.put(this.stagingDataPartitionLocation, finalDataPartitionLocation);
            List<String> dropPartitionsDDL = HiveAvroORCQueryGenerator.generateDropPartitionsDDL(this.outputDatabaseName, this.outputTableName, this.partitionsDMLInfo);
            log.debug("Drop partitions if exist in final table: " + dropPartitionsDDL);
            publishQueries.addAll(dropPartitionsDDL);
            List<String> createFinalPartitionDDL = HiveAvroORCQueryGenerator.generateCreatePartitionDDL(this.outputDatabaseName, this.outputTableName, finalDataPartitionLocation, this.partitionsDMLInfo, (Optional<String>)Optional.absent());
            log.debug("Create final partition DDL: " + createFinalPartitionDDL);
            publishQueries.addAll(createFinalPartitionDDL);
            String dropStagingTableDDL = HiveAvroORCQueryGenerator.generateDropTableDDL(this.outputDatabaseName, this.stagingTableName);
            log.debug("Drop staging table DDL: " + dropStagingTableDDL);
            cleanupQueries.add(dropStagingTableDDL);
            log.debug("Staging table directory to delete: " + this.stagingDataLocation);
            cleanupDirectories.add(this.stagingDataLocation);
            publishQueries.addAll(HiveAvroORCQueryGenerator.generateDropPartitionsDDL(this.outputDatabaseName, this.outputTableName, AbstractAvroToOrcConverter.getDropPartitionsDDLInfo(this.conversionEntity)));
        }
        log.info("Publish partition entity: " + publishEntity);
        return publishEntity;
    }
}

