/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.suite;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.action.CompactionCompleteFileOperationAction;
import org.apache.gobblin.compaction.action.CompactionHiveRegistrationAction;
import org.apache.gobblin.compaction.action.CompactionMarkDirectoryAction;
import org.apache.gobblin.compaction.mapreduce.CompactionJobConfigurator;
import org.apache.gobblin.compaction.suite.CompactionSuite;
import org.apache.gobblin.compaction.verify.CompactionAuditCountVerifier;
import org.apache.gobblin.compaction.verify.CompactionThresholdVerifier;
import org.apache.gobblin.compaction.verify.CompactionTimeRangeVerifier;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.io.GsonInterfaceAdapter;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionSuiteBase
implements CompactionSuite<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionSuiteBase.class);
    protected State state;
    private CompactionJobConfigurator configurator;
    private static final Gson GSON = GsonInterfaceAdapter.getGson(FileSystemDataset.class);
    private static final String SERIALIZED_DATASET = "compaction.serializedDataset";

    public CompactionSuiteBase(State state) {
        this.state = state;
    }

    @Override
    public List<CompactionVerifier<FileSystemDataset>> getDatasetsFinderVerifiers() {
        LinkedList<CompactionVerifier<FileSystemDataset>> list = new LinkedList<CompactionVerifier<FileSystemDataset>>();
        list.add(new CompactionTimeRangeVerifier(this.state));
        list.add(new CompactionThresholdVerifier(this.state));
        list.add(new CompactionAuditCountVerifier(this.state));
        return list;
    }

    @Override
    public List<CompactionVerifier<FileSystemDataset>> getMapReduceVerifiers() {
        return new ArrayList<CompactionVerifier<FileSystemDataset>>();
    }

    @Override
    public void save(FileSystemDataset dataset, State state) {
        state.setProp(SERIALIZED_DATASET, (Object)GSON.toJson((Object)dataset));
    }

    @Override
    public FileSystemDataset load(State state) {
        return (FileSystemDataset)GSON.fromJson(state.getProp(SERIALIZED_DATASET), FileSystemDataset.class);
    }

    @Override
    public List<CompactionCompleteAction<FileSystemDataset>> getCompactionCompleteActions() throws IOException {
        ArrayList<CompactionCompleteAction<FileSystemDataset>> compactionCompleteActionsList = new ArrayList<CompactionCompleteAction<FileSystemDataset>>();
        compactionCompleteActionsList.add(new CompactionCompleteFileOperationAction(this.state, this.getConfigurator()));
        compactionCompleteActionsList.add(new CompactionHiveRegistrationAction(this.state));
        compactionCompleteActionsList.add(new CompactionMarkDirectoryAction(this.state, this.getConfigurator()));
        return compactionCompleteActionsList;
    }

    @Override
    public Job createJob(FileSystemDataset dataset) throws IOException {
        return this.getConfigurator().createJob(dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompactionJobConfigurator getConfigurator() {
        if (this.configurator == null) {
            CompactionSuiteBase compactionSuiteBase = this;
            synchronized (compactionSuiteBase) {
                this.configurator = CompactionJobConfigurator.instantiateConfigurator(this.state);
            }
        }
        return this.configurator;
    }
}

