/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.test;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Calendar;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.gobblin.compaction.mapreduce.test.TestCompactionOrcJobConfigurator;
import org.apache.gobblin.compaction.mapreduce.test.TestCompactionTaskUtils;
import org.apache.gobblin.runtime.embedded.EmbeddedGobblin;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.tools.convert.ConvertTool;

public class TestOrcCompactionTask {
    private static final JsonParser PARSER = new JsonParser();
    private static final String HOURLY_SUBDIR = "tracking/testTopic/hourly";
    private static final String JSON_FILE_EXTENSION = "json";
    private static final String TEST_RESOURCE_FOLDER_NAME = "orcCompactionTest";

    public static void main(String[] args) throws Exception {
        File basePath = new File(System.getProperty("user.home"), TEST_RESOURCE_FOLDER_NAME);
        if (basePath.exists()) {
            FileUtils.deleteDirectory((File)basePath);
        }
        boolean mkdirs = basePath.mkdirs();
        Preconditions.checkArgument((boolean)mkdirs, (Object)("Unable to create: " + basePath.getAbsolutePath()));
        URL resourceURL = TestOrcCompactionTask.class.getClassLoader().getResource(TEST_RESOURCE_FOLDER_NAME);
        Preconditions.checkArgument((resourceURL != null ? 1 : 0) != 0, (Object)"Could not find resource: orcCompactionTest");
        File resourceDirectory = new File(resourceURL.getFile());
        for (File file : resourceDirectory.listFiles()) {
            if (!TestOrcCompactionTask.isJsonFile(file)) continue;
            TestOrcCompactionTask.createOrcFile(file, basePath.getAbsolutePath());
        }
        EmbeddedGobblin embeddedGobblin = TestCompactionTaskUtils.createEmbeddedGobblinCompactionJob("basic", basePath.getAbsolutePath(), "hourly").setConfiguration("compaction.jobConfiguratorFactory.class", TestCompactionOrcJobConfigurator.Factory.class.getName());
        embeddedGobblin.run();
    }

    private static void createOrcFile(File file, String basePath) throws IOException, ParseException {
        JsonElement jsonElement;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset());){
            jsonElement = PARSER.parse((Reader)reader);
        }
        long timestamp = jsonElement.getAsJsonObject().get("header").getAsJsonObject().get("time").getAsLong();
        File hourlyPath = new File(TestOrcCompactionTask.getPath(basePath, timestamp));
        if (!hourlyPath.exists()) {
            boolean result = hourlyPath.mkdirs();
            Preconditions.checkArgument((boolean)result, (Object)("Unable to create: " + hourlyPath.getAbsolutePath()));
        }
        String fileNameWithoutExtensions = Files.getNameWithoutExtension((String)file.getName());
        File schemaFile = new File(file.getParent(), fileNameWithoutExtensions + ".schema");
        String orcSchema = FileUtils.readFileToString((File)schemaFile, (Charset)Charset.defaultCharset());
        String orcFileName = hourlyPath.getAbsolutePath() + "/" + fileNameWithoutExtensions + ".orc";
        File orcFile = new File(orcFileName);
        if (orcFile.exists()) {
            boolean result = orcFile.delete();
            Preconditions.checkArgument((boolean)result, (Object)("Unable to delete: " + orcFile.getAbsolutePath()));
        }
        String[] convertToolArgs = new String[]{"-s", orcSchema, file.getAbsolutePath(), "-o", orcFileName};
        ConvertTool.main((Configuration)new Configuration(), (String[])convertToolArgs);
    }

    private static String getPath(String basePath, Long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        String year = Integer.toString(calendar.get(1));
        String month = String.format("%02d", calendar.get(2));
        String day = String.format("%02d", calendar.get(5));
        String hour = String.format("%02d", calendar.get(11));
        return Joiner.on((String)"/").join((Object)basePath, (Object)HOURLY_SUBDIR, new Object[]{year, month, day, hour});
    }

    private static boolean isJsonFile(File file) {
        return Files.getFileExtension((String)file.getName()).equals(JSON_FILE_EXTENSION);
    }
}

