/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import java.io.IOException;
import org.apache.gobblin.util.reflection.RestrictedFieldAccessingUtils;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.orc.StripeInformation;
import org.apache.orc.Writer;
import org.apache.orc.mapreduce.OrcMapreduceRecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinOrcMapreduceRecordWriter
extends OrcMapreduceRecordWriter {
    private static final Logger log = LoggerFactory.getLogger(GobblinOrcMapreduceRecordWriter.class);

    public GobblinOrcMapreduceRecordWriter(Writer writer) {
        super(writer);
    }

    public GobblinOrcMapreduceRecordWriter(Writer writer, int rowBatchSize) {
        super(writer, rowBatchSize);
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException {
        super.close(taskAttemptContext);
        try {
            String stripeSizeVec = ((Writer)RestrictedFieldAccessingUtils.getRestrictedFieldByReflection((Object)((Object)this), (String)"writer", ((Object)((Object)this)).getClass())).getStripes().stream().mapToLong(StripeInformation::getDataLength).mapToObj(String::valueOf).reduce((x, y) -> x.concat(",").concat((String)y)).get();
            log.info("The vector of Stripe-Size in enclosing writer is:" + stripeSizeVec);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("Failed to access writer object from super class to obtain stripe information");
        }
    }
}

