/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.gobblin.compaction.mapreduce.CompactionJobConfigurator;
import org.apache.gobblin.compaction.mapreduce.avro.AvroKeyCompactorOutputFormat;
import org.apache.gobblin.compaction.mapreduce.avro.AvroKeyDedupReducer;
import org.apache.gobblin.compaction.mapreduce.avro.AvroKeyMapper;
import org.apache.gobblin.compaction.mapreduce.avro.AvroKeyRecursiveCombineFileInputFormat;
import org.apache.gobblin.compaction.mapreduce.avro.MRCompactorAvroKeyDedupJobRunner;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.filter.AvroSchemaFieldRemover;
import org.apache.gobblin.util.AvroUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionAvroJobConfigurator
extends CompactionJobConfigurator {
    private static final Logger log = LoggerFactory.getLogger(CompactionAvroJobConfigurator.class);
    private Optional<String> keyFieldBlacklist;

    @Override
    public String getFileExtension() {
        return CompactionJobConfigurator.EXTENSION.AVRO.getExtensionString();
    }

    public CompactionAvroJobConfigurator(State state) throws IOException {
        super(state);
        this.keyFieldBlacklist = Optional.fromNullable((Object)state.getProp("compaction.job.key.fieldBlacklist"));
    }

    private MRCompactorAvroKeyDedupJobRunner.DedupKeyOption getDedupKeyOption() {
        if (!this.state.contains("compaction.job.dedup.key")) {
            return MRCompactorAvroKeyDedupJobRunner.DEFAULT_DEDUP_KEY_OPTION;
        }
        Optional option = Enums.getIfPresent(MRCompactorAvroKeyDedupJobRunner.DedupKeyOption.class, (String)this.state.getProp("compaction.job.dedup.key").toUpperCase());
        return option.isPresent() ? (MRCompactorAvroKeyDedupJobRunner.DedupKeyOption)((Object)option.get()) : MRCompactorAvroKeyDedupJobRunner.DEFAULT_DEDUP_KEY_OPTION;
    }

    @VisibleForTesting
    Schema getDedupKeySchema(Schema topicSchema) {
        boolean keySchemaFileSpecified = this.state.contains("compaction.job.avro.key.schema.loc");
        Schema keySchema = null;
        MRCompactorAvroKeyDedupJobRunner.DedupKeyOption dedupKeyOption = this.getDedupKeyOption();
        if (dedupKeyOption == MRCompactorAvroKeyDedupJobRunner.DedupKeyOption.ALL) {
            log.info("Using all attributes in the schema (except Map, Arrar and Enum fields) for compaction");
            keySchema = (Schema)AvroUtils.removeUncomparableFields((Schema)topicSchema).get();
        } else if (dedupKeyOption == MRCompactorAvroKeyDedupJobRunner.DedupKeyOption.KEY) {
            log.info("Using key attributes in the schema for compaction");
            keySchema = (Schema)AvroUtils.removeUncomparableFields((Schema)MRCompactorAvroKeyDedupJobRunner.getKeySchema(topicSchema)).get();
        } else if (keySchemaFileSpecified) {
            Path keySchemaFile = new Path(this.state.getProp("compaction.job.avro.key.schema.loc"));
            log.info("Using attributes specified in schema file " + keySchemaFile + " for compaction");
            try {
                keySchema = AvroUtils.parseSchemaFromFile((Path)keySchemaFile, (FileSystem)this.fs);
            }
            catch (IOException e) {
                log.error("Failed to parse avro schema from " + keySchemaFile + ", using key attributes in the schema for compaction");
                keySchema = (Schema)AvroUtils.removeUncomparableFields((Schema)MRCompactorAvroKeyDedupJobRunner.getKeySchema(topicSchema)).get();
            }
            if (!MRCompactorAvroKeyDedupJobRunner.isKeySchemaValid(keySchema, topicSchema)) {
                log.warn(String.format("Key schema %s is not compatible with record schema %s.", keySchema, topicSchema) + "Using key attributes in the schema for compaction");
                keySchema = (Schema)AvroUtils.removeUncomparableFields((Schema)MRCompactorAvroKeyDedupJobRunner.getKeySchema(topicSchema)).get();
            }
        } else {
            log.info("Property compaction.job.avro.key.schema.loc not provided. Using key attributes in the schema for compaction");
            keySchema = (Schema)AvroUtils.removeUncomparableFields((Schema)MRCompactorAvroKeyDedupJobRunner.getKeySchema(topicSchema)).get();
        }
        if (this.keyFieldBlacklist.isPresent()) {
            AvroSchemaFieldRemover fieldRemover = new AvroSchemaFieldRemover((String)this.keyFieldBlacklist.get());
            keySchema = fieldRemover.removeFields(keySchema);
            log.info("Adjusted key schema {}", (Object)keySchema);
        }
        return keySchema;
    }

    @Override
    protected void configureSchema(Job job) throws IOException {
        Schema newestSchema = MRCompactorAvroKeyDedupJobRunner.getNewestSchemaFromSource(job, this.fs);
        if (newestSchema != null) {
            if (this.state.getPropAsBoolean("compaction.job.avro.single.input.schema", true)) {
                AvroJob.setInputKeySchema((Job)job, (Schema)newestSchema);
            }
            AvroJob.setMapOutputKeySchema((Job)job, (Schema)(this.shouldDeduplicate ? this.getDedupKeySchema(newestSchema) : newestSchema));
            AvroJob.setMapOutputValueSchema((Job)job, (Schema)newestSchema);
            AvroJob.setOutputKeySchema((Job)job, (Schema)newestSchema);
        }
    }

    @Override
    protected void configureMapper(Job job) {
        job.setInputFormatClass(AvroKeyRecursiveCombineFileInputFormat.class);
        job.setMapperClass(AvroKeyMapper.class);
        job.setMapOutputKeyClass(AvroKey.class);
        job.setMapOutputValueClass(AvroValue.class);
    }

    @Override
    protected void configureReducer(Job job) throws IOException {
        job.setOutputFormatClass(AvroKeyCompactorOutputFormat.class);
        job.setReducerClass(AvroKeyDedupReducer.class);
        job.setOutputKeyClass(AvroKey.class);
        job.setOutputValueClass(NullWritable.class);
        this.setNumberOfReducers(job);
    }

    public static class Factory
    implements CompactionJobConfigurator.ConfiguratorFactory {
        @Override
        public CompactionJobConfigurator createConfigurator(State state) throws IOException {
            return new CompactionAvroJobConfigurator(state);
        }
    }
}

