/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hivebasedconstructs;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.List;
import org.apache.gobblin.compaction.hivebasedconstructs.MRCompactionEntity;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.conversion.hive.extractor.HiveBaseExtractor;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetadataForCompactionExtractor
extends HiveBaseExtractor<Void, MRCompactionEntity> {
    private static final Logger log = LoggerFactory.getLogger(HiveMetadataForCompactionExtractor.class);
    public static final String COMPACTION_PRIMARY_KEY = "hive.metastore.primaryKey";
    public static final String COMPACTION_DELTA = "hive.metastore.delta";
    private MRCompactionEntity compactionEntity;
    private boolean extracted = false;

    public HiveMetadataForCompactionExtractor(WorkUnitState state, FileSystem fs) throws IOException, TException {
        super(state);
        if (Boolean.valueOf(state.getPropAsBoolean("hive.source.watermark.isWatermarkWorkUnit")).booleanValue()) {
            log.info("Ignoring Watermark workunit for {}", (Object)state.getProp("dataset.urn"));
            return;
        }
        try (AutoReturnableObject client = this.pool.getClient();){
            Table table = ((IMetaStoreClient)client.get()).getTable(this.dbName, this.tableName);
            String primaryKeyString = (String)table.getParameters().get(state.getProp(COMPACTION_PRIMARY_KEY));
            List primaryKeyList = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)primaryKeyString);
            String deltaString = (String)table.getParameters().get(state.getProp(COMPACTION_DELTA));
            List deltaList = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)deltaString);
            Path dataFilesPath = new Path(table.getSd().getLocation());
            this.compactionEntity = new MRCompactionEntity(primaryKeyList, deltaList, dataFilesPath, state.getProperties());
        }
    }

    public MRCompactionEntity readRecord(MRCompactionEntity reuse) {
        if (!this.extracted) {
            this.extracted = true;
            return this.compactionEntity;
        }
        return null;
    }

    public Void getSchema() throws IOException {
        return null;
    }
}

