/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.gobblin.compaction.mapreduce.RecordKeyMapperBase;
import org.apache.gobblin.compaction.mapreduce.orc.OrcUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcKey;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcValueMapper
extends RecordKeyMapperBase<NullWritable, OrcStruct, Object, OrcValue> {
    private static final Logger log = LoggerFactory.getLogger(OrcValueMapper.class);
    private OrcKey outKey;
    private OrcValue outValue;
    private TypeDescription mrInputSchema;
    private TypeDescription shuffleKeySchema;
    private JobConf jobConf;
    private static int writeCount = 0;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.jobConf = new JobConf(context.getConfiguration());
        this.outKey = new OrcKey();
        this.outKey.configure(this.jobConf);
        this.outValue = new OrcValue();
        this.outValue.configure(this.jobConf);
        this.mrInputSchema = TypeDescription.fromString((String)context.getConfiguration().get(OrcConf.MAPRED_INPUT_SCHEMA.getAttribute()));
        this.shuffleKeySchema = TypeDescription.fromString((String)context.getConfiguration().get(OrcConf.MAPRED_SHUFFLE_KEY_SCHEMA.getAttribute()));
    }

    protected void map(NullWritable key, OrcStruct orcStruct, Mapper.Context context) throws IOException, InterruptedException {
        if (!orcStruct.getSchema().equals((Object)this.mrInputSchema)) {
            log.info("There's a schema difference between output schema and input schema");
            OrcUtils.upConvertOrcStruct(orcStruct, (OrcStruct)this.outValue.value, this.mrInputSchema);
        } else {
            this.outValue.value = orcStruct;
        }
        try {
            if (context.getNumReduceTasks() == 0) {
                context.write((Object)NullWritable.get(), (Object)this.outValue);
            } else {
                this.fillDedupKey(orcStruct);
                context.write((Object)this.outKey, (Object)this.outValue);
            }
        }
        catch (Exception e) {
            String inputPathInString = this.getInputsplitHelper(context);
            throw new RuntimeException("Failure in write record no." + writeCount + " the processing split is:" + inputPathInString, e);
        }
        ++writeCount;
        context.getCounter((Enum)RecordKeyMapperBase.EVENT_COUNTER.RECORD_COUNT).increment(1L);
    }

    private String getInputsplitHelper(Mapper.Context context) {
        try {
            Field mapContextField = WrappedMapper.Context.class.getDeclaredField("mapContext");
            mapContextField.setAccessible(true);
            Object[] inputPaths = ((CombineFileSplit)((MapContextImpl)mapContextField.get((WrappedMapper.Context)context)).getInputSplit()).getPaths();
            return Arrays.toString(inputPaths);
        }
        catch (IllegalAccessException | NoSuchFieldException ie) {
            throw new RuntimeException(ie);
        }
    }

    private void fillDedupKey(OrcStruct originalRecord) {
        if (!originalRecord.getSchema().equals((Object)this.shuffleKeySchema)) {
            OrcUtils.upConvertOrcStruct(originalRecord, (OrcStruct)this.outKey.key, this.shuffleKeySchema);
        } else {
            this.outKey.key = originalRecord;
        }
    }
}

