/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import java.io.IOException;
import org.apache.gobblin.compaction.mapreduce.CompactorOutputCommitter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.orc.OrcFile;
import org.apache.orc.Writer;
import org.apache.orc.mapreduce.OrcMapreduceRecordWriter;
import org.apache.orc.mapreduce.OrcOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcKeyCompactorOutputFormat
extends OrcOutputFormat {
    private static final Logger log = LoggerFactory.getLogger(OrcKeyCompactorOutputFormat.class);
    private FileOutputCommitter committer = null;

    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            this.committer = new CompactorOutputCommitter(FileOutputFormat.getOutputPath((JobContext)context), context);
        }
        return this.committer;
    }

    public RecordWriter getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration conf = taskAttemptContext.getConfiguration();
        String extension = "." + conf.get("compaction.output.extension", "orc");
        Path filename = this.getDefaultWorkFile(taskAttemptContext, extension);
        Writer writer = OrcFile.createWriter((Path)filename, (OrcFile.WriterOptions)org.apache.orc.mapred.OrcOutputFormat.buildOptions((Configuration)conf));
        int rowBatchSize = conf.getInt("orcWriter.batchSize", 1000);
        log.info("Creating OrcMapreduceRecordWriter with row batch size = {}", (Object)rowBatchSize);
        return new OrcMapreduceRecordWriter(writer, rowBatchSize);
    }
}

