/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.avro;

import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.compaction.mapreduce.RecordKeyMapperBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class AvroKeyMapper
extends RecordKeyMapperBase<AvroKey<GenericRecord>, NullWritable, AvroKey<GenericRecord>, Object> {
    private AvroKey<GenericRecord> outKey;
    private AvroValue<GenericRecord> outValue;
    private Schema keySchema;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.keySchema = AvroJob.getMapOutputKeySchema((Configuration)context.getConfiguration());
        this.outKey = new AvroKey();
        this.outKey.datum((Object)new GenericData.Record(this.keySchema));
        this.outValue = new AvroValue();
    }

    protected void map(AvroKey<GenericRecord> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        if (context.getNumReduceTasks() == 0) {
            context.write(key, (Object)NullWritable.get());
        } else {
            this.populateComparableKeyRecord((GenericRecord)key.datum(), (GenericRecord)this.outKey.datum());
            this.outValue.datum(key.datum());
            try {
                context.write(this.outKey, this.outValue);
            }
            catch (AvroRuntimeException e) {
                Object[] paths = ((CombineFileSplit)context.getInputSplit()).getPaths();
                throw new IOException("Unable to process paths " + StringUtils.join((Object[])paths, (char)','), e);
            }
        }
        context.getCounter((Enum)RecordKeyMapperBase.EVENT_COUNTER.RECORD_COUNT).increment(1L);
    }

    private void populateComparableKeyRecord(GenericRecord source, GenericRecord target) {
        block0: for (Schema.Field field : target.getSchema().getFields()) {
            if (field.schema().getType() == Schema.Type.UNION) {
                Object fieldData = source.get(field.name());
                Schema actualFieldSchema = GenericData.get().induce(fieldData);
                if (actualFieldSchema.getType() == Schema.Type.RECORD) {
                    for (Schema candidateType : field.schema().getTypes()) {
                        if (!candidateType.getFullName().equals(actualFieldSchema.getFullName())) continue;
                        GenericData.Record record = new GenericData.Record(candidateType);
                        target.put(field.name(), (Object)record);
                        this.populateComparableKeyRecord((GenericRecord)fieldData, (GenericRecord)record);
                        continue block0;
                    }
                    continue;
                }
                target.put(field.name(), source.get(field.name()));
                continue;
            }
            if (field.schema().getType() == Schema.Type.RECORD) {
                GenericRecord record = (GenericRecord)target.get(field.name());
                if (record == null) {
                    record = new GenericData.Record(field.schema());
                    target.put(field.name(), (Object)record);
                }
                this.populateComparableKeyRecord((GenericRecord)source.get(field.name()), record);
                continue;
            }
            target.put(field.name(), source.get(field.name()));
        }
    }
}

