/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.avro;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Comparator;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.gobblin.compaction.mapreduce.RecordKeyDedupReducerBase;
import org.apache.gobblin.compaction.mapreduce.avro.AvroDeltaFieldNameProvider;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;

public class AvroKeyDedupReducer
extends RecordKeyDedupReducerBase<AvroKey<GenericRecord>, AvroValue<GenericRecord>, AvroKey<GenericRecord>, NullWritable> {
    public static final String DELTA_SCHEMA_PROVIDER = "org.apache.gobblin.compaction." + AvroKeyDedupReducer.class.getSimpleName() + ".deltaFieldsProvider";

    @Override
    protected void initReusableObject() {
        this.outKey = new AvroKey();
        this.outValue = NullWritable.get();
    }

    @Override
    protected void setOutKey(AvroValue<GenericRecord> valueToRetain) {
        ((AvroKey)this.outKey).datum(valueToRetain.datum());
    }

    @Override
    protected void setOutValue(AvroValue<GenericRecord> valueToRetain) {
    }

    @Override
    protected void initDeltaComparator(Configuration conf) {
        this.deltaComparatorOptional = Optional.absent();
        String deltaSchemaProviderClassName = conf.get(DELTA_SCHEMA_PROVIDER);
        if (deltaSchemaProviderClassName != null) {
            this.deltaComparatorOptional = Optional.of((Object)new AvroValueDeltaSchemaComparator((AvroDeltaFieldNameProvider)GobblinConstructorUtils.invokeConstructor(AvroDeltaFieldNameProvider.class, (String)deltaSchemaProviderClassName, (Object[])new Object[]{conf})));
        }
    }

    @VisibleForTesting
    protected static class AvroValueDeltaSchemaComparator
    implements Comparator<AvroValue<GenericRecord>> {
        private final AvroDeltaFieldNameProvider deltaSchemaProvider;

        public AvroValueDeltaSchemaComparator(AvroDeltaFieldNameProvider provider) {
            this.deltaSchemaProvider = provider;
        }

        @Override
        public int compare(AvroValue<GenericRecord> o1, AvroValue<GenericRecord> o2) {
            GenericRecord record1 = (GenericRecord)o1.datum();
            GenericRecord record2 = (GenericRecord)o2.datum();
            for (String deltaFieldName : this.deltaSchemaProvider.getDeltaFieldNames(record1)) {
                if (record1.get(deltaFieldName).equals(record2.get(deltaFieldName))) continue;
                return ((Comparable)record1.get(deltaFieldName)).compareTo(record2.get(deltaFieldName));
            }
            return 0;
        }
    }
}

