/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import java.io.IOException;
import org.apache.gobblin.compaction.mapreduce.CompactionJobConfigurator;
import org.apache.gobblin.compaction.mapreduce.orc.OrcKeyCompactorOutputFormat;
import org.apache.gobblin.compaction.mapreduce.orc.OrcKeyComparator;
import org.apache.gobblin.compaction.mapreduce.orc.OrcKeyDedupReducer;
import org.apache.gobblin.compaction.mapreduce.orc.OrcUtils;
import org.apache.gobblin.compaction.mapreduce.orc.OrcValueCombineFileInputFormat;
import org.apache.gobblin.compaction.mapreduce.orc.OrcValueMapper;
import org.apache.gobblin.configuration.State;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcKey;
import org.apache.orc.mapred.OrcValue;

public class CompactionOrcJobConfigurator
extends CompactionJobConfigurator {
    public static final String ORC_MAPPER_SHUFFLE_KEY_SCHEMA = "orcMapperShuffleSchema";
    private String orcMapperShuffleSchemaString;

    public CompactionOrcJobConfigurator(State state) throws IOException {
        super(state);
        this.orcMapperShuffleSchemaString = state.getProp(ORC_MAPPER_SHUFFLE_KEY_SCHEMA, "");
    }

    @Override
    public String getFileExtension() {
        return this.state.getProp("compaction.output.extension", CompactionJobConfigurator.EXTENSION.ORC.getExtensionString());
    }

    @Override
    protected void configureSchema(Job job) throws IOException {
        TypeDescription schema = OrcUtils.getNewestSchemaFromSource(job, this.fs);
        job.getConfiguration().set(OrcConf.MAPRED_INPUT_SCHEMA.getAttribute(), schema.toString());
        if (!this.orcMapperShuffleSchemaString.isEmpty() && OrcUtils.eligibleForUpConvert(schema, TypeDescription.fromString((String)this.orcMapperShuffleSchemaString))) {
            job.getConfiguration().set(OrcConf.MAPRED_SHUFFLE_KEY_SCHEMA.getAttribute(), this.orcMapperShuffleSchemaString);
        } else {
            job.getConfiguration().set(OrcConf.MAPRED_SHUFFLE_KEY_SCHEMA.getAttribute(), schema.toString());
        }
        job.getConfiguration().set(OrcConf.MAPRED_SHUFFLE_VALUE_SCHEMA.getAttribute(), schema.toString());
        job.getConfiguration().set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), schema.toString());
    }

    private int getWriterRowBatchSize() {
        return this.state.getPropAsInt("orcWriter.batchSize", 1000);
    }

    protected void setOrcWriterBatchSize(Job job) {
        job.getConfiguration().setInt("orcWriter.batchSize", this.getWriterRowBatchSize());
    }

    @Override
    protected void configureMapper(Job job) {
        job.setInputFormatClass(OrcValueCombineFileInputFormat.class);
        job.setMapperClass(OrcValueMapper.class);
        job.setMapOutputKeyClass(OrcKey.class);
        job.setMapOutputValueClass(OrcValue.class);
        job.setGroupingComparatorClass(OrcKeyComparator.class);
        job.setSortComparatorClass(OrcKeyComparator.class);
    }

    @Override
    protected void configureReducer(Job job) throws IOException {
        job.setReducerClass(OrcKeyDedupReducer.class);
        job.setOutputFormatClass(OrcKeyCompactorOutputFormat.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(OrcValue.class);
        this.setNumberOfReducers(job);
        this.setOrcWriterBatchSize(job);
    }

    public static class Factory
    implements CompactionJobConfigurator.ConfiguratorFactory {
        @Override
        public CompactionJobConfigurator createConfigurator(State state) throws IOException {
            return new CompactionOrcJobConfigurator(state);
        }
    }
}

