/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.mapred.FsInput;
import org.apache.gobblin.compaction.hive.HdfsIO;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsReader
extends HdfsIO {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsReader.class);

    public HdfsReader(String filePathInHdfs) throws IOException {
        super(filePathInHdfs);
    }

    public InputStream getInputStream() throws IOException {
        return this.fileSystem.open(new Path(this.filePathInHdfs));
    }

    public FsInput getFsInput() throws IOException {
        Path path = new Path(this.filePathInHdfs);
        Configuration conf = HdfsReader.getConfiguration();
        return new FsInput(path, conf);
    }

    public static String getFirstDataFilePathInDir(String dirInHdfs) throws IOException {
        FileStatus[] fileStatuses;
        for (FileStatus fileStatus : fileStatuses = HdfsReader.getFileSystem().listStatus(new Path(dirInHdfs))) {
            Path dataFilePath = fileStatus.getPath();
            if (fileStatus.isDirectory() || dataFilePath.getName().startsWith("_")) continue;
            return dataFilePath.toString();
        }
        String message = dirInHdfs + " does not contain a valid data file.";
        LOG.error(message);
        throw new RuntimeException(message);
    }
}

