/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.action;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.parser.CompactionPathParser;
import org.apache.gobblin.compaction.verify.InputRecordCountHelper;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicy;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicyBase;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.metrics.event.CountEventBuilder;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.metrics.event.GobblinEventBuilder;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionHiveRegistrationAction
implements CompactionCompleteAction<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionHiveRegistrationAction.class);
    public static final String NUM_OUTPUT_FILES = "numOutputFiles";
    public static final String RECORD_COUNT = "recordCount";
    public static final String BYTE_COUNT = "byteCount";
    public static final String DATASET_URN = "datasetUrn";
    private final State state;
    private EventSubmitter eventSubmitter;
    private InputRecordCountHelper helper;

    public CompactionHiveRegistrationAction(State state) {
        if (!(state instanceof WorkUnitState)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only supports workunit state");
        }
        this.state = state;
    }

    @Override
    public void onCompactionJobComplete(FileSystemDataset dataset) throws IOException {
        if (dataset.isVirtual()) {
            return;
        }
        CompactionPathParser.CompactionParserResult result = new CompactionPathParser(this.state).parse(dataset);
        long numFiles = this.state.getPropAsLong("counter.fileCount", -1L);
        CountEventBuilder fileCountEvent = new CountEventBuilder(NUM_OUTPUT_FILES, numFiles);
        fileCountEvent.addMetadata(DATASET_URN, result.getDstAbsoluteDir());
        fileCountEvent.addMetadata(RECORD_COUNT, this.state.getProp("counter.recordCount", "-1"));
        fileCountEvent.addMetadata(BYTE_COUNT, this.state.getProp("counter.byteCount", "-1"));
        if (this.eventSubmitter != null) {
            this.eventSubmitter.submit((GobblinEventBuilder)fileCountEvent);
        } else {
            log.warn("Will not emit events in {} as EventSubmitter is null", (Object)this.getClass().getName());
        }
        if (!this.state.contains("hive.registration.policy")) {
            log.info("Will skip hive registration as {} is not configured.", (Object)"hive.registration.policy");
            return;
        }
        try (HiveRegister hiveRegister = HiveRegister.get((State)this.state);){
            this.state.setProp("topic.name", (Object)result.getDatasetName());
            HiveRegistrationPolicy hiveRegistrationPolicy = HiveRegistrationPolicyBase.getPolicy((State)this.state);
            ArrayList<String> paths = new ArrayList<String>();
            Path dstPath = new Path(result.getDstAbsoluteDir());
            if (this.state.getPropAsBoolean(ConfigurationKeys.RECOMPACTION_WRITE_TO_NEW_FOLDER, false)) {
                this.helper = new InputRecordCountHelper(this.state);
                long executionCount = this.helper.readExecutionCount(new Path(result.getDstAbsoluteDir()));
                dstPath = PathUtils.mergePaths((Path)dstPath, (Path)new Path(String.format("/compaction_%s", executionCount)));
            }
            for (HiveSpec spec : hiveRegistrationPolicy.getHiveSpecs(dstPath)) {
                hiveRegister.register(spec);
                paths.add(spec.getPath().toUri().toASCIIString());
                log.info("Hive registration is done for {}", (Object)dstPath.toString());
            }
            if (this.eventSubmitter != null) {
                ImmutableMap eventMetadataMap = ImmutableMap.of((Object)DATASET_URN, (Object)dataset.datasetURN(), (Object)"hiveRegistrationPaths", (Object)Joiner.on((char)',').join(paths));
                this.eventSubmitter.submit("CompactionHiveRegistration", (Map)eventMetadataMap);
            }
        }
    }

    @Override
    public void addEventSubmitter(EventSubmitter submitter) {
        this.eventSubmitter = submitter;
    }
}

