/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.source;

import org.apache.gobblin.compaction.suite.CompactionSuite;
import org.apache.gobblin.compaction.suite.CompactionSuiteUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.task.FailedTask;
import org.apache.gobblin.runtime.task.TaskIFace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionFailedTask
extends FailedTask {
    private static final Logger log = LoggerFactory.getLogger(CompactionFailedTask.class);
    protected final CompactionSuite suite;
    protected final Dataset dataset;
    protected final String failedReason;

    public CompactionFailedTask(TaskContext taskContext) {
        super(taskContext);
        this.suite = CompactionSuiteUtils.getCompactionSuiteFactory((State)taskContext.getTaskState()).createSuite((State)taskContext.getTaskState());
        this.dataset = this.suite.load((State)taskContext.getTaskState());
        this.failedReason = taskContext.getTaskState().getProp("compaction.verification.fail.reason");
    }

    public void run() {
        log.error("Compaction job for " + this.dataset.datasetURN() + " is failed because of {}", (Object)this.failedReason);
        this.workingState = WorkUnitState.WorkingState.FAILED;
    }

    public static class CompactionFailedTaskFactory
    extends FailedTask.FailedTaskFactory {
        public TaskIFace createTask(TaskContext taskContext) {
            return new CompactionFailedTask(taskContext);
        }
    }
}

