/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;

public abstract class RecordKeyDedupReducerBase<KI, VI, KO, VO>
extends Reducer<KI, VI, KO, VO> {
    protected KO outKey;
    protected VO outValue;
    protected Optional<Comparator<VI>> deltaComparatorOptional;

    protected abstract void initReusableObject();

    protected abstract void setOutKey(VI var1);

    protected abstract void setOutValue(VI var1);

    protected abstract void initDeltaComparator(Configuration var1);

    protected void setup(Reducer.Context context) {
        this.initReusableObject();
        this.initDeltaComparator(context.getConfiguration());
    }

    protected void reduce(KI key, Iterable<VI> values, Reducer.Context context) throws IOException, InterruptedException {
        int numVals = 0;
        Object valueToRetain = null;
        for (VI value : values) {
            if (valueToRetain == null) {
                valueToRetain = value;
            } else if (this.deltaComparatorOptional.isPresent()) {
                valueToRetain = ((Comparator)this.deltaComparatorOptional.get()).compare(valueToRetain, value) >= 0 ? valueToRetain : (Object)value;
            }
            ++numVals;
        }
        this.writeRetainedValue(valueToRetain, context);
        this.updateCounters(numVals, context);
    }

    protected void writeRetainedValue(VI valueToRetain, Reducer.Context context) throws IOException, InterruptedException {
        this.setOutKey(valueToRetain);
        this.setOutValue(valueToRetain);
        if (this.outKey == null || this.outValue == null) {
            throw new IllegalStateException("Either outKey or outValue is not being properly initialized");
        }
        context.write(this.outKey, this.outValue);
    }

    protected void updateCounters(int numDuplicates, Reducer.Context context) {
        if (numDuplicates > 1) {
            context.getCounter((Enum)EVENT_COUNTER.MORE_THAN_1).increment(1L);
            context.getCounter((Enum)EVENT_COUNTER.DEDUPED).increment((long)(numDuplicates - 1));
        }
        context.getCounter((Enum)EVENT_COUNTER.RECORD_COUNT).increment(1L);
    }

    public KO getOutKey() {
        return this.outKey;
    }

    public VO getOutValue() {
        return this.outValue;
    }

    public static enum EVENT_COUNTER {
        MORE_THAN_1,
        DEDUPED,
        RECORD_COUNT;

    }
}

