/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.avro;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyRecordReader;
import org.apache.gobblin.util.AvroUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class AvroKeyCombineFileRecordReader
extends AvroKeyRecordReader<GenericRecord> {
    private final CombineFileSplit split;
    private final Integer idx;

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public AvroKeyCombineFileRecordReader(CombineFileSplit split, TaskAttemptContext cx, Integer idx) throws IOException {
        this(split, AvroKeyCombineFileRecordReader.getSchema(split, cx, idx), idx);
    }

    private AvroKeyCombineFileRecordReader(CombineFileSplit split, Schema inputKeySchema, Integer idx) {
        super(inputKeySchema);
        this.split = split;
        this.idx = idx;
    }

    public void initialize(InputSplit unusedSplit, TaskAttemptContext cx) throws IOException, InterruptedException {
        super.initialize((InputSplit)new FileSplit(this.split.getPath(this.idx.intValue()), this.split.getOffset(this.idx.intValue()), this.split.getLength(this.idx.intValue()), null), cx);
    }

    private static Schema getSchema(CombineFileSplit split, TaskAttemptContext cx, Integer idx) throws IOException {
        Schema schema = AvroJob.getInputKeySchema((Configuration)cx.getConfiguration());
        if (schema != null) {
            return schema;
        }
        Path path = split.getPath(idx.intValue());
        FileSystem fs = path.getFileSystem(cx.getConfiguration());
        return AvroUtils.getSchemaFromDataFile((Path)path, (FileSystem)fs);
    }
}

