/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.dataset;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.compaction.conditions.RecompactionCondition;
import org.apache.gobblin.compaction.conditions.RecompactionConditionFactory;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.mapreduce.MRCompactor;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.RecordCountProvider;
import org.apache.gobblin.util.recordcount.LateFileRecordCountProvider;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetHelper {
    private final FileSystem fs;
    private final Dataset dataset;
    private final RecordCountProvider inputRecordCountProvider;
    private final RecordCountProvider outputRecordCountProvider;
    private final LateFileRecordCountProvider lateInputRecordCountProvider;
    private final LateFileRecordCountProvider lateOutputRecordCountProvider;
    private final RecompactionCondition condition;
    private final Collection<String> extensions;
    private static final Logger logger = LoggerFactory.getLogger(DatasetHelper.class);

    public DatasetHelper(Dataset dataset, FileSystem fs, Collection<String> extensions) {
        this.extensions = extensions;
        this.fs = fs;
        this.dataset = dataset;
        this.condition = this.createRecompactionCondition();
        try {
            this.inputRecordCountProvider = (RecordCountProvider)Class.forName(this.dataset.jobProps().getProp("compaction.input.record.count.provider", MRCompactor.DEFAULT_COMPACTION_INPUT_RECORD_COUNT_PROVIDER)).newInstance();
            this.outputRecordCountProvider = (RecordCountProvider)Class.forName(this.dataset.jobProps().getProp("compaction.output.record.count.provider", MRCompactor.DEFAULT_COMPACTION_OUTPUT_RECORD_COUNT_PROVIDER)).newInstance();
            this.lateInputRecordCountProvider = new LateFileRecordCountProvider(this.inputRecordCountProvider);
            this.lateOutputRecordCountProvider = new LateFileRecordCountProvider(this.outputRecordCountProvider);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate RecordCountProvider", e);
        }
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    private RecompactionCondition createRecompactionCondition() {
        ClassAliasResolver conditionClassAliasResolver = new ClassAliasResolver(RecompactionConditionFactory.class);
        String factoryName = this.dataset.jobProps().getProp("compaction.recompact.condition", "RecompactBasedOnRatio");
        try {
            RecompactionConditionFactory factory = (RecompactionConditionFactory)GobblinConstructorUtils.invokeFirstConstructor((Class)conditionClassAliasResolver.resolveClass(factoryName), (List[])new List[]{ImmutableList.of()});
            return factory.createRecompactionCondition(this.dataset);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<Path> getApplicableFilePaths(FileSystem fs, Path dataDir, final Collection<String> extensions) throws IOException {
        if (!fs.exists(dataDir)) {
            return Lists.newArrayList();
        }
        ArrayList paths = Lists.newArrayList();
        for (FileStatus fileStatus : FileListUtils.listFilesRecursively((FileSystem)fs, (Path)dataDir, (PathFilter)new PathFilter(){

            public boolean accept(Path path) {
                for (String validExtention : extensions) {
                    if (!path.getName().endsWith(validExtention)) continue;
                    return true;
                }
                return false;
            }
        })) {
            paths.add(fileStatus.getPath());
        }
        return paths;
    }

    public List<Path> getApplicableFilePaths(Path dataDir) throws IOException {
        return DatasetHelper.getApplicableFilePaths(this.fs, dataDir, Lists.newArrayList((Object[])new String[]{"avro"}));
    }

    public Optional<DateTime> getEarliestLateFileModificationTime() {
        DateTimeZone timeZone = DateTimeZone.forID((String)this.dataset.jobProps().getProp("compaction.timezone", "America/Los_Angeles"));
        try {
            long maxTimestamp = Long.MIN_VALUE;
            for (FileStatus status : FileListUtils.listFilesRecursively((FileSystem)this.fs, (Path)this.dataset.outputLatePath())) {
                maxTimestamp = Math.max(maxTimestamp, status.getModificationTime());
            }
            return maxTimestamp == Long.MIN_VALUE ? Optional.absent() : Optional.of((Object)new DateTime(maxTimestamp, timeZone));
        }
        catch (Exception e) {
            logger.error("Failed to get earliest late file modification time");
            return Optional.absent();
        }
    }

    public DateTime getCurrentTime() {
        DateTimeZone timeZone = DateTimeZone.forID((String)this.dataset.jobProps().getProp("compaction.timezone", "America/Los_Angeles"));
        DateTime currentTime = new DateTime(timeZone);
        return currentTime;
    }

    public long getLateOutputRecordCount() {
        long lateOutputRecordCount = 0L;
        try {
            Path outputLatePath = this.dataset.outputLatePath();
            if (this.fs.exists(outputLatePath)) {
                lateOutputRecordCount = this.lateOutputRecordCountProvider.getRecordCount(this.getApplicableFilePaths(this.dataset.outputLatePath()));
            }
        }
        catch (Exception e) {
            logger.error("Failed to get late record count:" + e, (Throwable)e);
        }
        return lateOutputRecordCount;
    }

    public long getOutputRecordCount() {
        long outputRecordCount = 1L;
        try {
            outputRecordCount = this.outputRecordCountProvider.getRecordCount(this.getApplicableFilePaths(this.dataset.outputPath()));
            return outputRecordCount;
        }
        catch (Exception e) {
            logger.error("Failed to submit late event count:" + e, (Throwable)e);
            return outputRecordCount;
        }
    }

    protected RecompactionCondition getCondition() {
        return this.condition;
    }

    public long getLateOutputFileCount() {
        long lateOutputFileCount = 0L;
        try {
            Path outputLatePath = this.dataset.outputLatePath();
            if (this.fs.exists(outputLatePath)) {
                lateOutputFileCount = this.getApplicableFilePaths(this.dataset.outputLatePath()).size();
                logger.info("LateOutput File Count is : " + lateOutputFileCount + " at " + outputLatePath.toString());
            }
        }
        catch (Exception e) {
            logger.error("Failed to get late file count from :" + e, (Throwable)e);
        }
        return lateOutputFileCount;
    }
}

