/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.conditions;

import com.google.common.base.Optional;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.compaction.conditions.RecompactionCondition;
import org.apache.gobblin.compaction.conditions.RecompactionConditionFactory;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.dataset.DatasetHelper;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="RecompactionConditionBasedOnDuration")
public class RecompactionConditionBasedOnDuration
implements RecompactionCondition {
    private final Period duration;
    private static final Logger logger = LoggerFactory.getLogger(RecompactionConditionBasedOnDuration.class);

    private RecompactionConditionBasedOnDuration(Dataset dataset) {
        this.duration = this.getOwnDurationThreshold(dataset);
    }

    private Period getOwnDurationThreshold(Dataset dataset) {
        String retention = dataset.jobProps().getProp("compaction.latedata.threshold.duration", "24h");
        Period period = RecompactionConditionBasedOnDuration.getPeriodFormatter().parsePeriod(retention);
        return period;
    }

    private static PeriodFormatter getPeriodFormatter() {
        return new PeriodFormatterBuilder().appendMonths().appendSuffix("m").appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("min").toFormatter();
    }

    @Override
    public boolean isRecompactionNeeded(DatasetHelper datasetHelper) {
        Optional<DateTime> earliestFileModificationTime = datasetHelper.getEarliestLateFileModificationTime();
        DateTime currentTime = datasetHelper.getCurrentTime();
        if (earliestFileModificationTime.isPresent()) {
            DateTime checkpoint = currentTime.minus((ReadablePeriod)this.duration);
            logger.info("Current time is " + currentTime + " checkpoint is " + checkpoint);
            logger.info("Earliest late file has timestamp " + earliestFileModificationTime.get() + " inside " + datasetHelper.getDataset().outputLatePath());
            if (((DateTime)earliestFileModificationTime.get()).isBefore((ReadableInstant)checkpoint)) {
                return true;
            }
        }
        return false;
    }

    @Alias(value="RecompactBasedOnDuration")
    public static class Factory
    implements RecompactionConditionFactory {
        @Override
        public RecompactionCondition createRecompactionCondition(Dataset dataset) {
            return new RecompactionConditionBasedOnDuration(dataset);
        }
    }
}

