/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.service.modules.orchestration.AzkabanClient;
import org.apache.gobblin.service.modules.orchestration.AzkabanClientException;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class SessionHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSessionId(CloseableHttpClient httpClient, String url, String username, String password) throws AzkabanClientException {
        try {
            HttpPost httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("action", "login"));
            nvps.add(new BasicNameValuePair("username", username));
            nvps.add(new BasicNameValuePair("password", password));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                String jsonResponseString = IOUtils.toString((InputStream)entity.getContent(), (String)"UTF-8");
                JsonObject jsonObject = AzkabanClient.parseResponse(jsonResponseString);
                Map<String, String> responseMap = AzkabanClient.getFlatMap(jsonObject);
                String sessionId = responseMap.get("session.id");
                EntityUtils.consume((HttpEntity)entity);
                String string = sessionId;
                return string;
            }
        }
        catch (Exception e) {
            throw new AzkabanClientException("Azkaban client cannot fetch session.", e);
        }
    }
}

