/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.runtime.spec_executorInstance.AbstractSpecExecutor;
import org.apache.gobblin.service.modules.orchestration.AzkabanSpecProducer;
import org.apache.gobblin.util.CompletedFuture;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.slf4j.Logger;

public class AzkabanSpecExecutor
extends AbstractSpecExecutor {
    protected final Config _config;
    private SpecProducer<Spec> azkabanSpecProducer;

    public AzkabanSpecExecutor(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public AzkabanSpecExecutor(Config config, Optional<Logger> log) {
        super(config, log);
        Config defaultConfig = ConfigFactory.load((String)"default-service-azkaban.conf");
        this._config = config.withFallback((ConfigMergeable)defaultConfig);
        try {
            Class<?> producerClass = Class.forName(ConfigUtils.getString((Config)this._config, (String)"gobblin.service.azkaban.producer.class", (String)AzkabanSpecProducer.class.getName()));
            this.azkabanSpecProducer = (SpecProducer)GobblinConstructorUtils.invokeLongestConstructor(producerClass, (Object[])new Object[]{this._config});
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null) {
                throw new RuntimeException("Could not instantiate spec producer", e.getCause());
            }
            throw new RuntimeException("Could not instantiate spec producer", e);
        }
    }

    public Future<String> getDescription() {
        return new CompletedFuture((Object)("SimpleSpecExecutorInstance with URI: " + this.specExecutorInstanceUri), null);
    }

    public Future<? extends SpecProducer<Spec>> getProducer() {
        return new CompletedFuture(this.azkabanSpecProducer, null);
    }

    public Future<Config> getConfig() {
        return new CompletedFuture((Object)this._config, null);
    }

    public Future<String> getHealth() {
        return new CompletedFuture((Object)"Healthy", null);
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }
}

