/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.service.modules.orchestration.AzkabanClient;
import org.apache.gobblin.service.modules.orchestration.AzkabanClientException;
import org.apache.gobblin.service.modules.orchestration.AzkabanClientStatus;
import org.apache.gobblin.service.modules.orchestration.AzkabanExecuteFlowStatus;
import org.apache.gobblin.service.modules.orchestration.AzkabanFetchExecuteFlowStatus;
import org.apache.gobblin.service.modules.orchestration.AzkabanGetProxyUsersStatus;
import org.apache.gobblin.service.modules.orchestration.AzkabanProjectFlowsStatus;
import org.apache.gobblin.service.modules.orchestration.AzkabanSuccess;
import org.apache.gobblin.service.modules.orchestration.InvalidSessionException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

class AzkabanMultiCallables {
    private AzkabanMultiCallables() {
    }

    static class GetProxyUserCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String projectName;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanClientStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("ajax", "getProxyUsers"));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add(new BasicNameValuePair("project", this.projectName));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                HttpGet httpGet = new HttpGet(this.client.url + "/manager?" + URLEncodedUtils.format(nvps, (String)"UTF-8"));
                httpGet.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpGet);
                closer.register((Closeable)response);
                Map<String, String> map = AzkabanClient.handleResponse((HttpResponse)response);
                AzkabanGetProxyUsersStatus azkabanGetProxyUsersStatus = new AzkabanGetProxyUsersStatus(new AzkabanGetProxyUsersStatus.ProxyUsers(map));
                return azkabanGetProxyUsersStatus;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Exception e) {
                throw new AzkabanClientException(String.format("Azkaban client failed to get proxy users for %s", this.client.url), e);
            }
        }

        GetProxyUserCallable(AzkabanClient client, String projectName, boolean invalidSession) {
            this.client = client;
            this.projectName = projectName;
            this.invalidSession = invalidSession;
        }

        public static GetProxyUserCallableBuilder builder() {
            return new GetProxyUserCallableBuilder();
        }

        public static class GetProxyUserCallableBuilder {
            private AzkabanClient client;
            private String projectName;
            private boolean invalidSession;

            GetProxyUserCallableBuilder() {
            }

            public GetProxyUserCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public GetProxyUserCallableBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public GetProxyUserCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public GetProxyUserCallable build() {
                return new GetProxyUserCallable(this.client, this.projectName, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.GetProxyUserCallable.GetProxyUserCallableBuilder(client=" + this.client + ", projectName=" + this.projectName + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class AddProxyUserCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String projectName;
        private String proxyUserName;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanClientStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("ajax", "addProxyUser"));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add(new BasicNameValuePair("project", this.projectName));
                nvps.add(new BasicNameValuePair("name", this.proxyUserName));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                HttpGet httpGet = new HttpGet(this.client.url + "/manager?" + URLEncodedUtils.format(nvps, (String)"UTF-8"));
                httpGet.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpGet);
                closer.register((Closeable)response);
                AzkabanClient.handleResponse((HttpResponse)response);
                AzkabanSuccess azkabanSuccess = new AzkabanSuccess();
                return azkabanSuccess;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Exception e) {
                throw new AzkabanClientException("Azkaban client cannot add proxy user " + this.proxyUserName, e);
            }
        }

        AddProxyUserCallable(AzkabanClient client, String projectName, String proxyUserName, boolean invalidSession) {
            this.client = client;
            this.projectName = projectName;
            this.proxyUserName = proxyUserName;
            this.invalidSession = invalidSession;
        }

        public static AddProxyUserCallableBuilder builder() {
            return new AddProxyUserCallableBuilder();
        }

        public static class AddProxyUserCallableBuilder {
            private AzkabanClient client;
            private String projectName;
            private String proxyUserName;
            private boolean invalidSession;

            AddProxyUserCallableBuilder() {
            }

            public AddProxyUserCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public AddProxyUserCallableBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public AddProxyUserCallableBuilder proxyUserName(String proxyUserName) {
                this.proxyUserName = proxyUserName;
                return this;
            }

            public AddProxyUserCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public AddProxyUserCallable build() {
                return new AddProxyUserCallable(this.client, this.projectName, this.proxyUserName, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.AddProxyUserCallable.AddProxyUserCallableBuilder(client=" + this.client + ", projectName=" + this.projectName + ", proxyUserName=" + this.proxyUserName + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class FetchExecLogCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String execId;
        private String jobId;
        private long offset;
        private long length;
        private OutputStream output;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanClientStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("ajax", "fetchExecJobLogs"));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add(new BasicNameValuePair("execid", this.execId));
                nvps.add(new BasicNameValuePair("jobId", this.jobId));
                nvps.add(new BasicNameValuePair("offset", String.valueOf(this.offset)));
                nvps.add(new BasicNameValuePair("length", String.valueOf(this.length)));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                HttpGet httpGet = new HttpGet(this.client.url + "/executor?" + URLEncodedUtils.format(nvps, (String)"UTF-8"));
                httpGet.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpGet);
                closer.register((Closeable)response);
                Map<String, String> map = AzkabanClient.handleResponse((HttpResponse)response);
                try (OutputStreamWriter logWriter = new OutputStreamWriter(this.output, StandardCharsets.UTF_8);){
                    logWriter.write(map.get("data"));
                }
                AzkabanSuccess azkabanSuccess = new AzkabanSuccess();
                return azkabanSuccess;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Exception e) {
                throw new AzkabanClientException("Azkaban client cannot fetch execId " + this.execId, e);
            }
        }

        FetchExecLogCallable(AzkabanClient client, String execId, String jobId, long offset, long length, OutputStream output, boolean invalidSession) {
            this.client = client;
            this.execId = execId;
            this.jobId = jobId;
            this.offset = offset;
            this.length = length;
            this.output = output;
            this.invalidSession = invalidSession;
        }

        public static FetchExecLogCallableBuilder builder() {
            return new FetchExecLogCallableBuilder();
        }

        public static class FetchExecLogCallableBuilder {
            private AzkabanClient client;
            private String execId;
            private String jobId;
            private long offset;
            private long length;
            private OutputStream output;
            private boolean invalidSession;

            FetchExecLogCallableBuilder() {
            }

            public FetchExecLogCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public FetchExecLogCallableBuilder execId(String execId) {
                this.execId = execId;
                return this;
            }

            public FetchExecLogCallableBuilder jobId(String jobId) {
                this.jobId = jobId;
                return this;
            }

            public FetchExecLogCallableBuilder offset(long offset) {
                this.offset = offset;
                return this;
            }

            public FetchExecLogCallableBuilder length(long length) {
                this.length = length;
                return this;
            }

            public FetchExecLogCallableBuilder output(OutputStream output) {
                this.output = output;
                return this;
            }

            public FetchExecLogCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public FetchExecLogCallable build() {
                return new FetchExecLogCallable(this.client, this.execId, this.jobId, this.offset, this.length, this.output, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.FetchExecLogCallable.FetchExecLogCallableBuilder(client=" + this.client + ", execId=" + this.execId + ", jobId=" + this.jobId + ", offset=" + this.offset + ", length=" + this.length + ", output=" + this.output + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class FetchProjectFlowsCallable
    implements Callable<AzkabanProjectFlowsStatus> {
        private AzkabanClient client;
        private boolean invalidSession = false;
        private String projectName;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanProjectFlowsStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("ajax", "fetchprojectflows"));
                nvps.add(new BasicNameValuePair("project", this.projectName));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                HttpGet httpGet = new HttpGet(this.client.url + "/manager?" + URLEncodedUtils.format(nvps, (String)"UTF-8"));
                httpGet.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpGet);
                closer.register((Closeable)response);
                AzkabanProjectFlowsStatus.Project project = AzkabanClient.handleResponse((HttpResponse)response, AzkabanProjectFlowsStatus.Project.class);
                AzkabanProjectFlowsStatus azkabanProjectFlowsStatus = new AzkabanProjectFlowsStatus(project);
                return azkabanProjectFlowsStatus;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Exception e) {
                throw new AzkabanClientException("Azkaban client cannot fetch project flows", e);
            }
        }

        FetchProjectFlowsCallable(AzkabanClient client, boolean invalidSession, String projectName) {
            this.client = client;
            this.invalidSession = invalidSession;
            this.projectName = projectName;
        }

        public static FetchProjectFlowsCallableBuilder builder() {
            return new FetchProjectFlowsCallableBuilder();
        }

        public static class FetchProjectFlowsCallableBuilder {
            private AzkabanClient client;
            private boolean invalidSession;
            private String projectName;

            FetchProjectFlowsCallableBuilder() {
            }

            public FetchProjectFlowsCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public FetchProjectFlowsCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public FetchProjectFlowsCallableBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public FetchProjectFlowsCallable build() {
                return new FetchProjectFlowsCallable(this.client, this.invalidSession, this.projectName);
            }

            public String toString() {
                return "AzkabanMultiCallables.FetchProjectFlowsCallable.FetchProjectFlowsCallableBuilder(client=" + this.client + ", invalidSession=" + this.invalidSession + ", projectName=" + this.projectName + ")";
            }
        }
    }

    static class FetchFlowExecCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String execId;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanFetchExecuteFlowStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("ajax", "fetchexecflow"));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add(new BasicNameValuePair("execid", this.execId));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                HttpGet httpGet = new HttpGet(this.client.url + "/executor?" + URLEncodedUtils.format(nvps, (String)"UTF-8"));
                httpGet.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpGet);
                closer.register((Closeable)response);
                Map<String, String> map = AzkabanClient.handleResponse((HttpResponse)response);
                AzkabanFetchExecuteFlowStatus azkabanFetchExecuteFlowStatus = new AzkabanFetchExecuteFlowStatus(new AzkabanFetchExecuteFlowStatus.Execution(map));
                return azkabanFetchExecuteFlowStatus;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Exception e) {
                throw new AzkabanClientException("Azkaban client cannot fetch execId " + this.execId, e);
            }
        }

        FetchFlowExecCallable(AzkabanClient client, String execId, boolean invalidSession) {
            this.client = client;
            this.execId = execId;
            this.invalidSession = invalidSession;
        }

        public static FetchFlowExecCallableBuilder builder() {
            return new FetchFlowExecCallableBuilder();
        }

        public static class FetchFlowExecCallableBuilder {
            private AzkabanClient client;
            private String execId;
            private boolean invalidSession;

            FetchFlowExecCallableBuilder() {
            }

            public FetchFlowExecCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public FetchFlowExecCallableBuilder execId(String execId) {
                this.execId = execId;
                return this;
            }

            public FetchFlowExecCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public FetchFlowExecCallable build() {
                return new FetchFlowExecCallable(this.client, this.execId, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.FetchFlowExecCallable.FetchFlowExecCallableBuilder(client=" + this.client + ", execId=" + this.execId + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class CancelFlowCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String execId;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanClientStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("ajax", "cancelFlow"));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add(new BasicNameValuePair("execid", String.valueOf(this.execId)));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                HttpGet httpGet = new HttpGet(this.client.url + "/executor?" + URLEncodedUtils.format(nvps, (String)"UTF-8"));
                httpGet.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpGet);
                closer.register((Closeable)response);
                AzkabanClient.handleResponse((HttpResponse)response);
                AzkabanSuccess azkabanSuccess = new AzkabanSuccess();
                return azkabanSuccess;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Exception e) {
                throw new AzkabanClientException("Azkaban client cannot cancel flow execId = " + this.execId, e);
            }
        }

        CancelFlowCallable(AzkabanClient client, String execId, boolean invalidSession) {
            this.client = client;
            this.execId = execId;
            this.invalidSession = invalidSession;
        }

        public static CancelFlowCallableBuilder builder() {
            return new CancelFlowCallableBuilder();
        }

        public static class CancelFlowCallableBuilder {
            private AzkabanClient client;
            private String execId;
            private boolean invalidSession;

            CancelFlowCallableBuilder() {
            }

            public CancelFlowCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public CancelFlowCallableBuilder execId(String execId) {
                this.execId = execId;
                return this;
            }

            public CancelFlowCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public CancelFlowCallable build() {
                return new CancelFlowCallable(this.client, this.execId, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.CancelFlowCallable.CancelFlowCallableBuilder(client=" + this.client + ", execId=" + this.execId + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class ExecuteFlowCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String projectName;
        private String flowName;
        private Map<String, String> flowOptions;
        private Map<String, String> flowParameters;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanExecuteFlowStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                HttpPost httpPost = new HttpPost(this.client.url + "/executor");
                ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
                nvps.add((NameValuePair)new BasicNameValuePair("ajax", "executeFlow"));
                nvps.add((NameValuePair)new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add((NameValuePair)new BasicNameValuePair("project", this.projectName));
                nvps.add((NameValuePair)new BasicNameValuePair("flow", this.flowName));
                nvps.add((NameValuePair)new BasicNameValuePair("concurrentOption", "ignore"));
                this.addFlowOptions(nvps, this.flowOptions);
                this.addFlowParameters(nvps, this.flowParameters);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                httpPost.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpPost);
                closer.register((Closeable)response);
                Map<String, String> map = AzkabanClient.handleResponse((HttpResponse)response);
                AzkabanExecuteFlowStatus azkabanExecuteFlowStatus = new AzkabanExecuteFlowStatus(new AzkabanExecuteFlowStatus.ExecuteId(map.get("execid")));
                return azkabanExecuteFlowStatus;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Exception e) {
                throw new AzkabanClientException("Azkaban client cannot execute flow = " + this.flowName, e);
            }
        }

        private void addFlowParameters(List<NameValuePair> nvps, Map<String, String> flowParams) {
            if (flowParams != null) {
                for (Map.Entry<String, String> entry : flowParams.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
                    nvps.add((NameValuePair)new BasicNameValuePair("flowOverride[" + key + "]", value));
                }
            }
        }

        private void addFlowOptions(List<NameValuePair> nvps, Map<String, String> flowOptions) {
            if (flowOptions != null) {
                for (Map.Entry<String, String> option : flowOptions.entrySet()) {
                    nvps.add((NameValuePair)new BasicNameValuePair(option.getKey(), option.getValue()));
                }
            }
        }

        ExecuteFlowCallable(AzkabanClient client, String projectName, String flowName, Map<String, String> flowOptions, Map<String, String> flowParameters, boolean invalidSession) {
            this.client = client;
            this.projectName = projectName;
            this.flowName = flowName;
            this.flowOptions = flowOptions;
            this.flowParameters = flowParameters;
            this.invalidSession = invalidSession;
        }

        public static ExecuteFlowCallableBuilder builder() {
            return new ExecuteFlowCallableBuilder();
        }

        public static class ExecuteFlowCallableBuilder {
            private AzkabanClient client;
            private String projectName;
            private String flowName;
            private Map<String, String> flowOptions;
            private Map<String, String> flowParameters;
            private boolean invalidSession;

            ExecuteFlowCallableBuilder() {
            }

            public ExecuteFlowCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public ExecuteFlowCallableBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public ExecuteFlowCallableBuilder flowName(String flowName) {
                this.flowName = flowName;
                return this;
            }

            public ExecuteFlowCallableBuilder flowOptions(Map<String, String> flowOptions) {
                this.flowOptions = flowOptions;
                return this;
            }

            public ExecuteFlowCallableBuilder flowParameters(Map<String, String> flowParameters) {
                this.flowParameters = flowParameters;
                return this;
            }

            public ExecuteFlowCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public ExecuteFlowCallable build() {
                return new ExecuteFlowCallable(this.client, this.projectName, this.flowName, this.flowOptions, this.flowParameters, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.ExecuteFlowCallable.ExecuteFlowCallableBuilder(client=" + this.client + ", projectName=" + this.projectName + ", flowName=" + this.flowName + ", flowOptions=" + this.flowOptions + ", flowParameters=" + this.flowParameters + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class UploadProjectCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String projectName;
        private File zipFile;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanClientStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                HttpPost httpPost = new HttpPost(this.client.url + "/manager");
                HttpEntity entity = MultipartEntityBuilder.create().addTextBody("session.id", this.client.sessionId).addTextBody("ajax", "upload").addTextBody("project", this.projectName).addBinaryBody("file", this.zipFile, ContentType.create((String)"application/zip"), this.zipFile.getName()).build();
                httpPost.setEntity(entity);
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpPost);
                closer.register((Closeable)response);
                AzkabanClient.handleResponse((HttpResponse)response);
                AzkabanSuccess azkabanSuccess = new AzkabanSuccess();
                return azkabanSuccess;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Throwable e) {
                throw new AzkabanClientException("Azkaban client cannot upload zip to project = " + this.projectName, e);
            }
        }

        UploadProjectCallable(AzkabanClient client, String projectName, File zipFile, boolean invalidSession) {
            this.client = client;
            this.projectName = projectName;
            this.zipFile = zipFile;
            this.invalidSession = invalidSession;
        }

        public static UploadProjectCallableBuilder builder() {
            return new UploadProjectCallableBuilder();
        }

        public static class UploadProjectCallableBuilder {
            private AzkabanClient client;
            private String projectName;
            private File zipFile;
            private boolean invalidSession;

            UploadProjectCallableBuilder() {
            }

            public UploadProjectCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public UploadProjectCallableBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public UploadProjectCallableBuilder zipFile(File zipFile) {
                this.zipFile = zipFile;
                return this;
            }

            public UploadProjectCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public UploadProjectCallable build() {
                return new UploadProjectCallable(this.client, this.projectName, this.zipFile, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.UploadProjectCallable.UploadProjectCallableBuilder(client=" + this.client + ", projectName=" + this.projectName + ", zipFile=" + this.zipFile + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class DeleteProjectCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String projectName;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanClientStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("delete", "true"));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add(new BasicNameValuePair("project", this.projectName));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                HttpGet httpGet = new HttpGet(this.client.url + "/manager?" + URLEncodedUtils.format(nvps, (String)"UTF-8"));
                httpGet.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpGet);
                closer.register((Closeable)response);
                AzkabanClient.verifyStatusCode((HttpResponse)response);
                AzkabanSuccess azkabanSuccess = new AzkabanSuccess();
                return azkabanSuccess;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Throwable e) {
                throw new AzkabanClientException("Azkaban client cannot delete project = " + this.projectName, e);
            }
        }

        DeleteProjectCallable(AzkabanClient client, String projectName, boolean invalidSession) {
            this.client = client;
            this.projectName = projectName;
            this.invalidSession = invalidSession;
        }

        public static DeleteProjectCallableBuilder builder() {
            return new DeleteProjectCallableBuilder();
        }

        public static class DeleteProjectCallableBuilder {
            private AzkabanClient client;
            private String projectName;
            private boolean invalidSession;

            DeleteProjectCallableBuilder() {
            }

            public DeleteProjectCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public DeleteProjectCallableBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public DeleteProjectCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public DeleteProjectCallable build() {
                return new DeleteProjectCallable(this.client, this.projectName, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.DeleteProjectCallable.DeleteProjectCallableBuilder(client=" + this.client + ", projectName=" + this.projectName + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }

    static class CreateProjectCallable
    implements Callable<AzkabanClientStatus> {
        private AzkabanClient client;
        private String projectName;
        private String description;
        private boolean invalidSession = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AzkabanClientStatus call() throws AzkabanClientException {
            try (Closer closer = Closer.create();){
                this.client.refreshSession(this.invalidSession);
                HttpPost httpPost = new HttpPost(this.client.url + "/manager");
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("action", "create"));
                nvps.add(new BasicNameValuePair("session.id", this.client.sessionId));
                nvps.add(new BasicNameValuePair("name", this.projectName));
                nvps.add(new BasicNameValuePair("description", this.description));
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
                BasicHeader contentType = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                BasicHeader requestType = new BasicHeader("X-Requested-With", "XMLHttpRequest");
                httpPost.setHeaders(new Header[]{contentType, requestType});
                CloseableHttpResponse response = this.client.httpClient.execute((HttpUriRequest)httpPost);
                closer.register((Closeable)response);
                AzkabanClient.handleResponse((HttpResponse)response);
                AzkabanSuccess azkabanSuccess = new AzkabanSuccess();
                return azkabanSuccess;
            }
            catch (InvalidSessionException e) {
                this.invalidSession = true;
                throw e;
            }
            catch (Throwable e) {
                throw new AzkabanClientException("Azkaban client cannot create project = " + this.projectName, e);
            }
        }

        CreateProjectCallable(AzkabanClient client, String projectName, String description, boolean invalidSession) {
            this.client = client;
            this.projectName = projectName;
            this.description = description;
            this.invalidSession = invalidSession;
        }

        public static CreateProjectCallableBuilder builder() {
            return new CreateProjectCallableBuilder();
        }

        public static class CreateProjectCallableBuilder {
            private AzkabanClient client;
            private String projectName;
            private String description;
            private boolean invalidSession;

            CreateProjectCallableBuilder() {
            }

            public CreateProjectCallableBuilder client(AzkabanClient client) {
                this.client = client;
                return this;
            }

            public CreateProjectCallableBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public CreateProjectCallableBuilder description(String description) {
                this.description = description;
                return this;
            }

            public CreateProjectCallableBuilder invalidSession(boolean invalidSession) {
                this.invalidSession = invalidSession;
                return this;
            }

            public CreateProjectCallable build() {
                return new CreateProjectCallable(this.client, this.projectName, this.description, this.invalidSession);
            }

            public String toString() {
                return "AzkabanMultiCallables.CreateProjectCallable.CreateProjectCallableBuilder(client=" + this.client + ", projectName=" + this.projectName + ", description=" + this.description + ", invalidSession=" + this.invalidSession + ")";
            }
        }
    }
}

