/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.service.modules.orchestration.AzkabanClient;
import org.apache.gobblin.service.modules.orchestration.AzkabanProjectConfig;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AzkabanAjaxAPIClient {
    private static final Logger log = LoggerFactory.getLogger(AzkabanAjaxAPIClient.class);
    private static Splitter SPLIT_ON_COMMA = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final int LOW_NETWORK_TRAFFIC_BEGIN_HOUR = 17;
    private static final int LOW_NETWORK_TRAFFIC_END_HOUR = 22;
    private static final int JOB_START_DELAY_MINUTES = 5;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final URLCodec codec = new URLCodec();

    public static String authenticateAndGetSessionId(String username, String password, String azkabanServerUrl) throws IOException, EncoderException {
        HashMap params = Maps.newHashMap();
        params.put("action", "login");
        params.put("username", username);
        params.put("password", codec.encode(password));
        return AzkabanAjaxAPIClient.executePostRequest(AzkabanAjaxAPIClient.preparePostRequest(azkabanServerUrl, null, params)).get("session.id");
    }

    public static String getProjectId(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put("ajax", "fetchprojectflows");
        params.put("project", azkabanProjectConfig.getAzkabanProjectName());
        return AzkabanAjaxAPIClient.executeGetRequest(AzkabanAjaxAPIClient.prepareGetRequest(azkabanProjectConfig.getAzkabanServerUrl() + "/manager", sessionId, params)).get("projectId");
    }

    public static String createAzkabanProject(String sessionId, String zipFilePath, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put("ajax", "executeFlow");
        params.put("name", azkabanProjectConfig.getAzkabanProjectName());
        params.put("description", azkabanProjectConfig.getAzkabanProjectDescription());
        AzkabanAjaxAPIClient.executePostRequest(AzkabanAjaxAPIClient.preparePostRequest(azkabanProjectConfig.getAzkabanServerUrl() + "/manager?action=create", sessionId, params));
        if (azkabanProjectConfig.getAzkabanUserToProxy().isPresent()) {
            Iterable proxyUsers = SPLIT_ON_COMMA.split((CharSequence)azkabanProjectConfig.getAzkabanUserToProxy().get());
            for (String user : proxyUsers) {
                AzkabanAjaxAPIClient.addProxyUser(sessionId, azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName(), user);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)azkabanProjectConfig.getAzkabanGroupAdminUsers())) {
            String[] groups;
            for (String group : groups = StringUtils.split((String)azkabanProjectConfig.getAzkabanGroupAdminUsers(), (String)",")) {
                AzkabanAjaxAPIClient.addUserPermission(sessionId, azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName(), group, true, true, false, false, false, false);
            }
        }
        return AzkabanAjaxAPIClient.uploadZipFileToAzkaban(sessionId, azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName(), zipFilePath);
    }

    public static void deleteAzkabanProject(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put("delete", "true");
        params.put("project", azkabanProjectConfig.getAzkabanProjectName());
        AzkabanAjaxAPIClient.executeGetRequest(AzkabanAjaxAPIClient.prepareGetRequest(azkabanProjectConfig.getAzkabanServerUrl() + "/manager", sessionId, params));
    }

    public static String replaceAzkabanProject(String sessionId, String zipFilePath, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        AzkabanAjaxAPIClient.changeProjectDescription(sessionId, azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName(), azkabanProjectConfig.getAzkabanProjectDescription());
        if (azkabanProjectConfig.getAzkabanUserToProxy().isPresent()) {
            Iterable proxyUsers = SPLIT_ON_COMMA.split((CharSequence)azkabanProjectConfig.getAzkabanUserToProxy().get());
            for (String user : proxyUsers) {
                AzkabanAjaxAPIClient.addProxyUser(sessionId, azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName(), user);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)azkabanProjectConfig.getAzkabanGroupAdminUsers())) {
            String[] groups;
            for (String group : groups = StringUtils.split((String)azkabanProjectConfig.getAzkabanGroupAdminUsers(), (String)",")) {
                try {
                    AzkabanAjaxAPIClient.addUserPermission(sessionId, azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName(), group, true, true, false, false, false, false);
                }
                catch (IOException e) {
                    if ("Group permission already exists.".equalsIgnoreCase(e.getMessage())) continue;
                    throw e;
                }
            }
        }
        return AzkabanAjaxAPIClient.uploadZipFileToAzkaban(sessionId, azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName(), zipFilePath);
    }

    private static void addProxyUser(String sessionId, String azkabanServerUrl, String azkabanProjectName, String proxyUser) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put("ajax", "addProxyUser");
        params.put("project", azkabanProjectName);
        params.put("name", proxyUser);
        AzkabanAjaxAPIClient.executeGetRequest(AzkabanAjaxAPIClient.prepareGetRequest(azkabanServerUrl + "/manager", sessionId, params));
    }

    private static void addUserPermission(String sessionId, String azkabanServerUrl, String azkabanProjectName, String name, boolean isGroup, boolean adminPermission, boolean readPermission, boolean writePermission, boolean executePermission, boolean schedulePermission) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put("ajax", "addPermission");
        params.put("project", azkabanProjectName);
        params.put("name", name);
        params.put("group", Boolean.toString(isGroup));
        params.put("permissions[admin]", Boolean.toString(adminPermission));
        params.put("permissions[read]", Boolean.toString(readPermission));
        params.put("permissions[write]", Boolean.toString(writePermission));
        params.put("permissions[execute]", Boolean.toString(executePermission));
        params.put("permissions[schedule]", Boolean.toString(schedulePermission));
        AzkabanAjaxAPIClient.executeGetRequest(AzkabanAjaxAPIClient.prepareGetRequest(azkabanServerUrl + "/manager", sessionId, params));
    }

    public static void scheduleAzkabanProject(String sessionId, String azkabanProjectId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put("ajax", "scheduleFlow");
        params.put("projectName", azkabanProjectConfig.getAzkabanProjectName());
        params.put("flow", azkabanProjectConfig.getAzkabanProjectFlowName());
        params.put("projectId", azkabanProjectId);
        params.put("scheduleTime", AzkabanAjaxAPIClient.getScheduledTimeInAzkabanFormat(17, 22, 5));
        params.put("scheduleDate", AzkabanAjaxAPIClient.getScheduledDateInAzkabanFormat());
        params.put("is_recurring", "off");
        AzkabanAjaxAPIClient.executePostRequest(AzkabanAjaxAPIClient.preparePostRequest(azkabanProjectConfig.getAzkabanServerUrl() + "/schedule", sessionId, params));
    }

    private static void changeProjectDescription(String sessionId, String azkabanServerUrl, String azkabanProjectName, String projectDescription) throws IOException {
        String encodedProjectDescription;
        try {
            encodedProjectDescription = new URLCodec().encode(projectDescription);
        }
        catch (EncoderException e) {
            throw new IOException("Could not encode Azkaban project description", e);
        }
        HashMap params = Maps.newHashMap();
        params.put("ajax", "changeDescription");
        params.put("project", azkabanProjectName);
        params.put("description", encodedProjectDescription);
        AzkabanAjaxAPIClient.executeGetRequest(AzkabanAjaxAPIClient.prepareGetRequest(azkabanServerUrl + "/manager", sessionId, params));
    }

    public static void executeAzkabanProject(String sessionId, String azkabanProjectId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put("ajax", "executeFlow");
        params.put("project", azkabanProjectConfig.getAzkabanProjectName());
        params.put("flow", azkabanProjectConfig.getAzkabanProjectFlowName());
        AzkabanAjaxAPIClient.executePostRequest(AzkabanAjaxAPIClient.preparePostRequest(azkabanProjectConfig.getAzkabanServerUrl() + "/executor", sessionId, params));
    }

    private static HttpGet prepareGetRequest(String requestUrl, String sessionId, Map<String, String> params) throws IOException {
        StringBuilder stringEntityBuilder = new StringBuilder();
        stringEntityBuilder.append(String.format("?session.id=%s", sessionId));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            stringEntityBuilder.append(String.format("&%s=%s", entry.getKey(), entry.getValue()));
        }
        return new HttpGet(requestUrl + stringEntityBuilder);
    }

    private static HttpPost preparePostRequest(String requestUrl, String sessionId, Map<String, String> params) throws IOException {
        HttpPost postRequest = new HttpPost(requestUrl);
        StringBuilder stringEntityBuilder = new StringBuilder();
        stringEntityBuilder.append(String.format("session.id=%s", sessionId));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (stringEntityBuilder.length() > 0) {
                stringEntityBuilder.append("&");
            }
            stringEntityBuilder.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        StringEntity input = new StringEntity(stringEntityBuilder.toString());
        input.setContentType("application/x-www-form-urlencoded");
        postRequest.setEntity((HttpEntity)input);
        postRequest.setHeader("X-Requested-With", "XMLHttpRequest");
        return postRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected static Map<String, String> executeGetRequest(HttpGet getRequest) throws IOException {
        CloseableHttpClient httpClient = AzkabanAjaxAPIClient.getHttpClient();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            Map<String, String> map = AzkabanClient.handleResponse((HttpResponse)response);
            return map;
        }
        finally {
            if (Collections.singletonList(httpClient).get(0) != null) {
                httpClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected static Map<String, String> executePostRequest(HttpPost postRequest) throws IOException {
        CloseableHttpClient httpClient = AzkabanAjaxAPIClient.getHttpClient();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            Map<String, String> map = AzkabanClient.handleResponse((HttpResponse)response);
            return map;
        }
        finally {
            if (Collections.singletonList(httpClient).get(0) != null) {
                httpClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadZipFileToAzkaban(String sessionId, String azkabanServerUrl, String azkabanProjectName, String jobZipFile) throws IOException {
        HttpPost postRequest = new HttpPost(azkabanServerUrl + "/manager");
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("session.id", sessionId).addTextBody("ajax", "upload").addBinaryBody("file", new File(jobZipFile), ContentType.create((String)"application/zip"), azkabanProjectName + ".zip").addTextBody("project", azkabanProjectName).build();
        postRequest.setEntity(entity);
        CloseableHttpClient httpClient = AzkabanAjaxAPIClient.getHttpClient();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            String string = AzkabanClient.handleResponse((HttpResponse)response).get("projectId");
            return string;
        }
        finally {
            if (Collections.singletonList(httpClient).get(0) != null) {
                httpClient.close();
            }
        }
    }

    private static CloseableHttpClient getHttpClient() throws IOException {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException("Issue with creating http client", e);
        }
    }

    @SuppressWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="As expected for randomization")
    public static String getScheduledTimeInAzkabanFormat(int windowStartHour, int windowEndHour, int delayMinutes) {
        if (windowStartHour < 0 || windowEndHour > 23 || windowStartHour >= windowEndHour) {
            throw new IllegalArgumentException("Window start should be less than window end, and both should be between 0 and 23");
        }
        if (delayMinutes < 0 || delayMinutes > 59) {
            throw new IllegalArgumentException("Delay in minutes should be between 0 and 59 (inclusive)");
        }
        Calendar windowStartTime = Calendar.getInstance();
        windowStartTime.set(11, windowStartHour);
        windowStartTime.set(12, 0);
        windowStartTime.set(13, 0);
        Calendar windowEndTime = Calendar.getInstance();
        windowEndTime.set(11, windowEndHour);
        windowEndTime.set(12, 0);
        windowEndTime.set(13, 0);
        Calendar now = Calendar.getInstance();
        if (now.after(windowStartTime) && now.before(windowEndTime)) {
            now.add(12, delayMinutes);
            return new SimpleDateFormat("hh,mm,a,z").format(now.getTime());
        }
        int allowedSchedulingWindow = (int)((windowEndTime.getTimeInMillis() - windowStartTime.getTimeInMillis()) / 3600000L);
        int randomHourInWindow = new Random(System.currentTimeMillis()).nextInt(allowedSchedulingWindow);
        int randomMinute = new Random(System.currentTimeMillis()).nextInt(60);
        windowStartTime.add(10, randomHourInWindow);
        windowStartTime.set(12, randomMinute);
        return new SimpleDateFormat("hh,mm,a,z").format(windowStartTime.getTime());
    }

    private static String getScheduledDateInAzkabanFormat() {
        return new SimpleDateFormat("MM/dd/yyyy").format(new Date());
    }
}

