/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.azkaban;

import azkaban.jobExecutor.AbstractJob;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AzkabanJobRunner {
    private File baseDirectory = new File(".");
    private final List<String> commonProps;
    private final List<String> jobProps;
    private final Map<String, String> overrides;

    static void doMain(Class<? extends AzkabanJobRunner> klazz, String[] args) throws Exception {
        AzkabanJobRunner runner = klazz.newInstance();
        if (args.length >= 1) {
            runner.setBaseDirectory(new File(args[0]));
        }
        runner.run();
    }

    public static String getTempDirectory() {
        File tmpDirectory = Files.createTempDir();
        tmpDirectory.deleteOnExit();
        return tmpDirectory.getAbsolutePath();
    }

    private void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void run() throws IOException {
        Props commonProps = new Props();
        for (String commonPropsFile : this.commonProps) {
            commonProps = new Props(commonProps, new File(this.baseDirectory, commonPropsFile));
        }
        for (String jobFile : this.jobProps) {
            File file = new File(this.baseDirectory, jobFile);
            Props jobProps = new Props(new Props(commonProps, file), new Map[]{this.overrides});
            jobProps = PropsUtils.resolveProps((Props)jobProps);
            try {
                AbstractJob job = this.constructAbstractJob(file.getName(), jobProps);
                job.run();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private AbstractJob constructAbstractJob(String name, Props jobProps) {
        try {
            return (AbstractJob)jobProps.getClass("job.class").getConstructor(String.class, Props.class).newInstance(name, jobProps);
        }
        catch (ReflectiveOperationException roe) {
            try {
                return (AbstractJob)jobProps.getClass("job.class").getConstructor(String.class, Properties.class).newInstance(name, this.propsToProperties(jobProps));
            }
            catch (ReflectiveOperationException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    private Properties propsToProperties(Props props) {
        Properties properties = new Properties();
        for (String key : props.getKeySet()) {
            properties.put(key, props.getString(key));
        }
        return properties;
    }

    public AzkabanJobRunner(List<String> commonProps, List<String> jobProps, Map<String, String> overrides) {
        this.commonProps = commonProps;
        this.jobProps = jobProps;
        this.overrides = overrides;
    }
}

