/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.util.ConfigUtils;

public class AzkabanProjectConfig {
    private final String azkabanServerUrl;
    private final String azkabanProjectName;
    private final String azkabanProjectDescription;
    private final String azkabanProjectFlowName;
    private final String azkabanGroupAdminUsers;
    private final Optional<String> azkabanUserToProxy;
    private final Optional<List<String>> azkabanZipJarNames;
    private final Optional<String> azkabanZipJarUrlTemplate;
    private final Optional<String> azkabanZipJarVersion;
    private final Optional<List<String>> azkabanZipAdditionalFiles;
    private final Boolean failIfJarNotFound;
    private final JobSpec jobSpec;
    public static final String USER_TO_PROXY = "user.to.proxy";

    public AzkabanProjectConfig(JobSpec jobSpec) {
        this.jobSpec = jobSpec;
        Config defaultConfig = ConfigFactory.load((String)"default-service-azkaban.conf");
        Config config = jobSpec.getConfig().withFallback((ConfigMergeable)defaultConfig);
        this.azkabanServerUrl = config.getString("gobblin.service.azkaban.server.url");
        this.azkabanProjectName = AzkabanProjectConfig.constructProjectName(jobSpec, config);
        this.azkabanProjectDescription = config.getString("gobblin.service.azkaban.project.description");
        this.azkabanProjectFlowName = config.getString("gobblin.service.azkaban.project.flowName");
        this.azkabanGroupAdminUsers = ConfigUtils.getString((Config)config, (String)"gobblin.service.azkaban.project.groupAdmins", (String)"");
        this.azkabanUserToProxy = Optional.ofNullable(ConfigUtils.getString((Config)config, (String)"gobblin.service.azkaban.project.userToProxy", null));
        this.azkabanZipJarNames = Optional.ofNullable(ConfigUtils.getStringList((Config)config, (String)"gobblin.service.azkaban.project.zip.jarNames"));
        this.azkabanZipJarUrlTemplate = Optional.ofNullable(ConfigUtils.getString((Config)config, (String)"gobblin.service.azkaban.project.zip.jarUrlTemplate", null));
        this.azkabanZipJarVersion = Optional.ofNullable(ConfigUtils.getString((Config)config, (String)"gobblin.service.azkaban.project.zip.jarVersion", null));
        this.azkabanZipAdditionalFiles = config.hasPath("gobblin.service.azkaban.project.zip.additionalFilesUrl") && StringUtils.isNotBlank((String)config.getString("gobblin.service.azkaban.project.zip.additionalFilesUrl")) ? Optional.ofNullable(ConfigUtils.getStringList((Config)config, (String)"gobblin.service.azkaban.project.zip.additionalFilesUrl")) : Optional.empty();
        this.failIfJarNotFound = ConfigUtils.getBoolean((Config)config, (String)"gobblin.service.azkaban.project.zip.failIfJarNotFound", (boolean)false);
    }

    public static String constructProjectName(JobSpec jobSpec, Config config) {
        String projectNamePrefix = ConfigUtils.getString((Config)config, (String)"gobblin.service.azkaban.project.namePrefix", (String)"");
        String projectNamePostfix = null == jobSpec.getUri() ? "" : jobSpec.getUri().toString().replaceAll("_", "-").replaceAll("[^A-Za-z0-9\\-]", "_");
        return AzkabanProjectConfig.trimProjectName(String.format("%s_%s", projectNamePrefix, projectNamePostfix));
    }

    public String getAzkabanProjectZipFilename() {
        return String.format("%s.zip", this.azkabanProjectName);
    }

    public String getWorkDir() {
        return String.format("%s/%s/%s/%s", System.getProperty("user.dir"), "serviceAzkaban", this.azkabanProjectName, System.currentTimeMillis());
    }

    private static String trimProjectName(String projectName) {
        if (projectName.length() > 64) {
            int pathHash = projectName.hashCode();
            if (pathHash < 0) {
                pathHash *= -1;
            }
            projectName = String.format("%s_%s", projectName.substring(0, 53), pathHash);
        }
        return projectName;
    }

    public static AzkabanProjectConfigBuilder hiddenBuilder() {
        return new AzkabanProjectConfigBuilder();
    }

    public String getAzkabanServerUrl() {
        return this.azkabanServerUrl;
    }

    public String getAzkabanProjectName() {
        return this.azkabanProjectName;
    }

    public String getAzkabanProjectDescription() {
        return this.azkabanProjectDescription;
    }

    public String getAzkabanProjectFlowName() {
        return this.azkabanProjectFlowName;
    }

    public String getAzkabanGroupAdminUsers() {
        return this.azkabanGroupAdminUsers;
    }

    public Optional<String> getAzkabanUserToProxy() {
        return this.azkabanUserToProxy;
    }

    public Optional<List<String>> getAzkabanZipJarNames() {
        return this.azkabanZipJarNames;
    }

    public Optional<String> getAzkabanZipJarUrlTemplate() {
        return this.azkabanZipJarUrlTemplate;
    }

    public Optional<String> getAzkabanZipJarVersion() {
        return this.azkabanZipJarVersion;
    }

    public Optional<List<String>> getAzkabanZipAdditionalFiles() {
        return this.azkabanZipAdditionalFiles;
    }

    public Boolean getFailIfJarNotFound() {
        return this.failIfJarNotFound;
    }

    public JobSpec getJobSpec() {
        return this.jobSpec;
    }

    public String toString() {
        return "AzkabanProjectConfig(azkabanServerUrl=" + this.getAzkabanServerUrl() + ", azkabanProjectName=" + this.getAzkabanProjectName() + ", azkabanProjectDescription=" + this.getAzkabanProjectDescription() + ", azkabanProjectFlowName=" + this.getAzkabanProjectFlowName() + ", azkabanGroupAdminUsers=" + this.getAzkabanGroupAdminUsers() + ", azkabanUserToProxy=" + this.getAzkabanUserToProxy() + ", azkabanZipJarNames=" + this.getAzkabanZipJarNames() + ", azkabanZipJarUrlTemplate=" + this.getAzkabanZipJarUrlTemplate() + ", azkabanZipJarVersion=" + this.getAzkabanZipJarVersion() + ", azkabanZipAdditionalFiles=" + this.getAzkabanZipAdditionalFiles() + ", failIfJarNotFound=" + this.getFailIfJarNotFound() + ", jobSpec=" + this.getJobSpec() + ")";
    }

    @ConstructorProperties(value={"azkabanServerUrl", "azkabanProjectName", "azkabanProjectDescription", "azkabanProjectFlowName", "azkabanGroupAdminUsers", "azkabanUserToProxy", "azkabanZipJarNames", "azkabanZipJarUrlTemplate", "azkabanZipJarVersion", "azkabanZipAdditionalFiles", "failIfJarNotFound", "jobSpec"})
    public AzkabanProjectConfig(String azkabanServerUrl, String azkabanProjectName, String azkabanProjectDescription, String azkabanProjectFlowName, String azkabanGroupAdminUsers, Optional<String> azkabanUserToProxy, Optional<List<String>> azkabanZipJarNames, Optional<String> azkabanZipJarUrlTemplate, Optional<String> azkabanZipJarVersion, Optional<List<String>> azkabanZipAdditionalFiles, Boolean failIfJarNotFound, JobSpec jobSpec) {
        this.azkabanServerUrl = azkabanServerUrl;
        this.azkabanProjectName = azkabanProjectName;
        this.azkabanProjectDescription = azkabanProjectDescription;
        this.azkabanProjectFlowName = azkabanProjectFlowName;
        this.azkabanGroupAdminUsers = azkabanGroupAdminUsers;
        this.azkabanUserToProxy = azkabanUserToProxy;
        this.azkabanZipJarNames = azkabanZipJarNames;
        this.azkabanZipJarUrlTemplate = azkabanZipJarUrlTemplate;
        this.azkabanZipJarVersion = azkabanZipJarVersion;
        this.azkabanZipAdditionalFiles = azkabanZipAdditionalFiles;
        this.failIfJarNotFound = failIfJarNotFound;
        this.jobSpec = jobSpec;
    }

    public static class AzkabanProjectConfigBuilder {
        private String azkabanServerUrl;
        private String azkabanProjectName;
        private String azkabanProjectDescription;
        private String azkabanProjectFlowName;
        private String azkabanGroupAdminUsers;
        private Optional<String> azkabanUserToProxy;
        private Optional<List<String>> azkabanZipJarNames;
        private Optional<String> azkabanZipJarUrlTemplate;
        private Optional<String> azkabanZipJarVersion;
        private Optional<List<String>> azkabanZipAdditionalFiles;
        private Boolean failIfJarNotFound;
        private JobSpec jobSpec;

        AzkabanProjectConfigBuilder() {
        }

        public AzkabanProjectConfigBuilder azkabanServerUrl(String azkabanServerUrl) {
            this.azkabanServerUrl = azkabanServerUrl;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanProjectName(String azkabanProjectName) {
            this.azkabanProjectName = azkabanProjectName;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanProjectDescription(String azkabanProjectDescription) {
            this.azkabanProjectDescription = azkabanProjectDescription;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanProjectFlowName(String azkabanProjectFlowName) {
            this.azkabanProjectFlowName = azkabanProjectFlowName;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanGroupAdminUsers(String azkabanGroupAdminUsers) {
            this.azkabanGroupAdminUsers = azkabanGroupAdminUsers;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanUserToProxy(Optional<String> azkabanUserToProxy) {
            this.azkabanUserToProxy = azkabanUserToProxy;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanZipJarNames(Optional<List<String>> azkabanZipJarNames) {
            this.azkabanZipJarNames = azkabanZipJarNames;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanZipJarUrlTemplate(Optional<String> azkabanZipJarUrlTemplate) {
            this.azkabanZipJarUrlTemplate = azkabanZipJarUrlTemplate;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanZipJarVersion(Optional<String> azkabanZipJarVersion) {
            this.azkabanZipJarVersion = azkabanZipJarVersion;
            return this;
        }

        public AzkabanProjectConfigBuilder azkabanZipAdditionalFiles(Optional<List<String>> azkabanZipAdditionalFiles) {
            this.azkabanZipAdditionalFiles = azkabanZipAdditionalFiles;
            return this;
        }

        public AzkabanProjectConfigBuilder failIfJarNotFound(Boolean failIfJarNotFound) {
            this.failIfJarNotFound = failIfJarNotFound;
            return this;
        }

        public AzkabanProjectConfigBuilder jobSpec(JobSpec jobSpec) {
            this.jobSpec = jobSpec;
            return this;
        }

        public AzkabanProjectConfig build() {
            return new AzkabanProjectConfig(this.azkabanServerUrl, this.azkabanProjectName, this.azkabanProjectDescription, this.azkabanProjectFlowName, this.azkabanGroupAdminUsers, this.azkabanUserToProxy, this.azkabanZipJarNames, this.azkabanZipJarUrlTemplate, this.azkabanZipJarVersion, this.azkabanZipAdditionalFiles, this.failIfJarNotFound, this.jobSpec);
        }

        public String toString() {
            return "AzkabanProjectConfig.AzkabanProjectConfigBuilder(azkabanServerUrl=" + this.azkabanServerUrl + ", azkabanProjectName=" + this.azkabanProjectName + ", azkabanProjectDescription=" + this.azkabanProjectDescription + ", azkabanProjectFlowName=" + this.azkabanProjectFlowName + ", azkabanGroupAdminUsers=" + this.azkabanGroupAdminUsers + ", azkabanUserToProxy=" + this.azkabanUserToProxy + ", azkabanZipJarNames=" + this.azkabanZipJarNames + ", azkabanZipJarUrlTemplate=" + this.azkabanZipJarUrlTemplate + ", azkabanZipJarVersion=" + this.azkabanZipJarVersion + ", azkabanZipAdditionalFiles=" + this.azkabanZipAdditionalFiles + ", failIfJarNotFound=" + this.failIfJarNotFound + ", jobSpec=" + this.jobSpec + ")";
        }
    }
}

