/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention;

import azkaban.jobExecutor.AbstractJob;
import azkaban.utils.Props;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.data.management.retention.DatasetCleaner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class DatasetCleanerJob
extends AbstractJob
implements Tool {
    private Configuration conf;
    private DatasetCleaner datasetCleaner;

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new DatasetCleanerJob(DatasetCleanerJob.class.getName()), (String[])args);
    }

    public DatasetCleanerJob(String id) throws Exception {
        super(id, Logger.getLogger(DatasetCleanerJob.class));
    }

    public DatasetCleanerJob(String id, Properties props) throws IOException {
        super(id, Logger.getLogger(DatasetCleanerJob.class));
        this.conf = new Configuration();
        this.datasetCleaner = new DatasetCleaner(FileSystem.get((Configuration)this.getConf()), props);
    }

    public DatasetCleanerJob(String id, Props props) throws IOException {
        super(id, Logger.getLogger(DatasetCleanerJob.class));
        this.conf = new Configuration();
        this.datasetCleaner = new DatasetCleaner(FileSystem.get((Configuration)this.getConf()), props.toProperties());
    }

    public void run() throws Exception {
        if (this.datasetCleaner != null) {
            this.datasetCleaner.clean();
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Must provide properties file as first argument.");
            return 1;
        }
        Props props = new Props(null, args[0]);
        new DatasetCleanerJob(DatasetCleanerJob.class.getName(), props).run();
        return 0;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

