/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.azkaban;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.gobblin.azkaban.AzkabanJobRunner;
import org.apache.gobblin.testing.AssertWithBackoff;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.collections.Lists;

public class EmbeddedGobblinYarnAppLauncher
extends AzkabanJobRunner {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedGobblinYarnAppLauncher.class);
    public static final String DYNAMIC_CONF_PATH = "dynamic.conf";
    public static final String YARN_SITE_XML_PATH = "yarn-site.xml";
    private static String zkString = "";
    private static String fileAddress = "";

    private static void setup(String[] args) throws Exception {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0);
        zkString = args[0];
        Closer closer = Closer.create();
        String javaHome = System.getProperty("java.home");
        EmbeddedGobblinYarnAppLauncher.setEnv("JAVA_HOME", javaHome);
        final YarnConfiguration clusterConf = new YarnConfiguration();
        clusterConf.set("yarn.resourcemanager.connect.max-wait.ms", "10000");
        clusterConf.set("yarn.nodemanager.resource.memory-mb", "512");
        clusterConf.set("yarn.scheduler.maximum-allocation-mb", "1024");
        MiniYARNCluster miniYARNCluster = (MiniYARNCluster)closer.register((Closeable)new MiniYARNCluster("TestCluster", 1, 1, 1));
        miniYARNCluster.init((Configuration)clusterConf);
        miniYARNCluster.start();
        AssertWithBackoff.create().logger(log).timeoutMs(10000L).assertTrue((Predicate)new Predicate<Void>(){

            public boolean apply(Void input) {
                return !clusterConf.get("yarn.resourcemanager.address").contains(":0");
            }
        }, "Waiting for RM");
        try (PrintWriter pw = new PrintWriter(DYNAMIC_CONF_PATH, "UTF-8");){
            File dir = new File("target/dummydir");
            if (!dir.mkdir()) {
                log.error("The dummy folder's creation is not successful");
            }
            dir.deleteOnExit();
            pw.println("gobblin.cluster.zk.connection.string=\"" + zkString + "\"");
            pw.println("jobconf.fullyQualifiedPath=\"" + dir.getAbsolutePath() + "\"");
        }
        var6_6 = null;
        try (FileOutputStream os = new FileOutputStream(new File(YARN_SITE_XML_PATH));){
            clusterConf.writeXml((OutputStream)os);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        fileAddress = new File(YARN_SITE_XML_PATH).getAbsolutePath();
    }

    static void setEnv(String key, String value) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> cl = env.getClass();
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map writableEnv = (Map)field.get(env);
            writableEnv.put(key, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set environment variable", e);
        }
    }

    public static void main(String[] args) throws Exception {
        EmbeddedGobblinYarnAppLauncher.setup(args);
        AzkabanJobRunner.doMain(EmbeddedGobblinYarnAppLauncher.class, args);
    }

    public EmbeddedGobblinYarnAppLauncher() {
        super(Lists.newArrayList((Object[])new String[]{"gobblin-modules/gobblin-azkaban/src/main/resources/conf/properties/common.properties", "gobblin-modules/gobblin-azkaban/src/main/resources/conf/properties/local.properties"}), Lists.newArrayList((Object[])new String[]{"gobblin-modules/gobblin-azkaban/src/main/resources/conf/jobs/kafka-streaming-on-yarn.job"}), (Map<String, String>)ImmutableMap.of((Object)"yarn.resourcemanager.connect.max-wait.ms", (Object)"10000", (Object)"gobblin.cluster.zk.connection.string", (Object)zkString, (Object)"gobblin.cluster.job.conf.path", (Object)"gobblin-modules/gobblin-azkaban/src/main/resources/conf/gobblin_jobs", (Object)"gobblin.yarn.conf.dir", (Object)"gobblin-modules/gobblin-azkaban/src/main/resources/conf/gobblin_conf", (Object)"yarn-site-address", (Object)fileAddress));
    }
}

