/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.azkaban;

import azkaban.jobExecutor.AbstractJob;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.yarn.GobblinYarnAppLauncher;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AzkabanGobblinYarnAppLauncher
extends AbstractJob {
    private static final Logger LOGGER = Logger.getLogger(AzkabanGobblinYarnAppLauncher.class);
    private final GobblinYarnAppLauncher gobblinYarnAppLauncher;
    private final YarnConfiguration yarnConfiguration;

    public AzkabanGobblinYarnAppLauncher(String jobId, Properties gobblinProps) throws IOException {
        super(jobId, LOGGER);
        Config gobblinConfig = ConfigUtils.propertiesToConfig((Properties)gobblinProps);
        this.setLogLevelForClasses(gobblinConfig);
        this.yarnConfiguration = this.initYarnConf(gobblinProps);
        gobblinConfig = gobblinConfig.withValue("gobblin.yarn.appLauncherMode", ConfigValueFactory.fromAnyRef((Object)"azkaban"));
        this.gobblinYarnAppLauncher = new GobblinYarnAppLauncher(gobblinConfig, this.yarnConfiguration);
    }

    private void setLogLevelForClasses(Config config) {
        List classLogLevels = ConfigUtils.getStringList((Config)config, (String)"gobblin.yarn.azkaban.class.logLevels");
        for (String classLogLevel : classLogLevels) {
            String className = classLogLevel.split(":")[0];
            Level level = Level.toLevel((String)classLogLevel.split(":")[1], (Level)Level.INFO);
            Logger.getLogger((String)className).setLevel(level);
        }
    }

    protected YarnConfiguration initYarnConf(Properties gobblinProps) {
        return new YarnConfiguration();
    }

    public void run() throws Exception {
        this.gobblinYarnAppLauncher.launch();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AzkabanGobblinYarnAppLauncher.this.gobblinYarnAppLauncher.stop();
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)("Failed to shutdown the " + GobblinYarnAppLauncher.class.getSimpleName()), (Throwable)ioe);
                }
                catch (TimeoutException te) {
                    LOGGER.error((Object)("Timed out in shutting down the " + GobblinYarnAppLauncher.class.getSimpleName()), (Throwable)te);
                }
            }
        });
    }

    public void cancel() throws Exception {
        try {
            this.gobblinYarnAppLauncher.stop();
        }
        finally {
            super.cancel();
        }
    }

    public YarnConfiguration getYarnConfiguration() {
        return this.yarnConfiguration;
    }
}

