/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.service.modules.orchestration.AzkabanAjaxAPIClient;
import org.apache.gobblin.service.modules.orchestration.AzkabanJobHelper;
import org.apache.gobblin.service.modules.orchestration.AzkabanProjectConfig;
import org.apache.gobblin.util.CompletedFuture;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzkabanSpecProducer
implements SpecProducer<Spec>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(AzkabanSpecProducer.class);
    private String _sessionId;
    private Config _config;

    public AzkabanSpecProducer(Config config, Optional<Logger> log) {
        this._config = config;
        try {
            String azkabanUsername = this._config.getString("gobblin.service.azkaban.username");
            String azkabanPassword = this.getAzkabanPassword(this._config);
            String azkabanServerUrl = this._config.getString("gobblin.service.azkaban.server.url");
            this._sessionId = AzkabanAjaxAPIClient.authenticateAndGetSessionId(azkabanUsername, azkabanPassword, azkabanServerUrl);
        }
        catch (IOException | EncoderException e) {
            throw new RuntimeException("Could not authenticate with Azkaban", e);
        }
    }

    private String getAzkabanPassword(Config config) {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("GOBBLIN_SERVICE_AZKABAN_PASSWORD"))) {
            return System.getProperty("GOBBLIN_SERVICE_AZKABAN_PASSWORD");
        }
        return ConfigUtils.getString((Config)config, (String)"gobblin.service.azkaban.password", (String)"");
    }

    public AzkabanSpecProducer(Config config, Logger log) {
        this(config, (Optional<Logger>)Optional.of((Object)log));
    }

    public AzkabanSpecProducer(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    @Override
    public void close() throws IOException {
    }

    public Future<?> addSpec(Spec addedSpec) {
        block8: {
            try {
                AzkabanProjectConfig azkabanProjectConfig = new AzkabanProjectConfig((JobSpec)addedSpec);
                boolean azkabanProjectExists = AzkabanJobHelper.isAzkabanJobPresent(this._sessionId, azkabanProjectConfig);
                if (azkabanProjectExists) {
                    log.info("Executing Azkaban Project: " + azkabanProjectConfig.getAzkabanProjectName());
                    AzkabanJobHelper.executeJob(this._sessionId, AzkabanJobHelper.getProjectId(this._sessionId, azkabanProjectConfig), azkabanProjectConfig);
                    break block8;
                }
                log.info("Setting up Azkaban Project: " + azkabanProjectConfig.getAzkabanProjectName());
                try {
                    this.createNewAzkabanProject(this._sessionId, azkabanProjectConfig);
                }
                catch (IOException e) {
                    if ("Project already exists.".equalsIgnoreCase(e.getMessage())) {
                        if (ConfigUtils.getBoolean((Config)((JobSpec)addedSpec).getConfig(), (String)"gobblin.service.azkaban.project.overwriteIfExists", (boolean)false)) {
                            log.info("Project already exists for this Spec, but force overwrite specified");
                            this.updateExistingAzkabanProject(this._sessionId, azkabanProjectConfig);
                        } else {
                            log.info(String.format("Azkaban project already exists: %smanager?project=%s", azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName()));
                        }
                        break block8;
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Issue in setting up Azkaban project.", e);
            }
        }
        return new CompletedFuture((Object)this._config, null);
    }

    public Future<?> updateSpec(Spec updatedSpec) {
        AzkabanProjectConfig azkabanProjectConfig = new AzkabanProjectConfig((JobSpec)updatedSpec);
        try {
            this.updateExistingAzkabanProject(this._sessionId, azkabanProjectConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Issue in setting up Azkaban project.", e);
        }
        return new CompletedFuture((Object)this._config, null);
    }

    public Future<?> deleteSpec(URI deletedSpecURI, Properties headers) {
        JobSpec jobSpec = new JobSpec.Builder(deletedSpecURI).build();
        try {
            AzkabanJobHelper.deleteAzkabanJob(this._sessionId, new AzkabanProjectConfig(jobSpec));
        }
        catch (IOException e) {
            throw new RuntimeException("Issue in deleting Azkaban project.", e);
        }
        throw new UnsupportedOperationException();
    }

    public Future<? extends List<Spec>> listSpecs() {
        throw new UnsupportedOperationException();
    }

    private void createNewAzkabanProject(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        String azkabanProjectId = AzkabanJobHelper.createAzkabanJob(sessionId, azkabanProjectConfig);
        AzkabanJobHelper.scheduleJob(sessionId, azkabanProjectId, azkabanProjectConfig);
        log.info(String.format("Azkaban project created: %smanager?project=%s", azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName()));
    }

    private void updateExistingAzkabanProject(String sessionId, AzkabanProjectConfig azkabanProjectConfig) throws IOException {
        log.info(String.format("Updating project: %smanager?project=%s", azkabanProjectConfig.getAzkabanServerUrl(), azkabanProjectConfig.getAzkabanProjectName()));
        String azkabanProjectId = AzkabanJobHelper.getProjectId(sessionId, azkabanProjectConfig);
        AzkabanJobHelper.replaceAzkabanJob(sessionId, azkabanProjectId, azkabanProjectConfig);
        AzkabanJobHelper.changeJobSchedule(sessionId, azkabanProjectId, azkabanProjectConfig);
    }
}

