/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.aws;

import com.amazonaws.util.EC2MetadataUtils;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.aws.Log4jConfigHelper;
import org.apache.gobblin.cluster.GobblinTaskRunner;
import org.apache.gobblin.util.JvmUtils;
import org.apache.hadoop.fs.Path;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MultiTypeMessageHandlerFactory;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinAWSTaskRunner
extends GobblinTaskRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinTaskRunner.class);

    public GobblinAWSTaskRunner(String applicationName, String helixInstanceName, Config config, Optional<Path> appWorkDirOptional) throws Exception {
        super(applicationName, helixInstanceName, GobblinAWSTaskRunner.getApplicationId(), GobblinAWSTaskRunner.getTaskRunnerId(), config, appWorkDirOptional);
    }

    public List<Service> getServices() {
        return super.getServices();
    }

    public MultiTypeMessageHandlerFactory getUserDefinedMessageHandlerFactory() {
        return new ParticipantUserDefinedMessageHandlerFactory();
    }

    private static String getApplicationId() {
        return "1";
    }

    private static String getTaskRunnerId() {
        return (String)((EC2MetadataUtils.NetworkInterface)EC2MetadataUtils.getNetworkInterfaces().get(0)).getPublicIPv4s().get(0);
    }

    public static Options buildOptions() {
        Options options = new Options();
        options.addOption("a", "app_name", true, "Application name");
        options.addOption("i", "helix_instance_name", true, "Helix instance name");
        options.addOption("d", "gobblin.aws.work.dir", true, "Application work directory");
        return options;
    }

    public static void main(String[] args) throws Exception {
        Options options = GobblinAWSTaskRunner.buildOptions();
        try {
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (!(cmd.hasOption("app_name") && cmd.hasOption("helix_instance_name") && cmd.hasOption("gobblin.aws.work.dir"))) {
                GobblinAWSTaskRunner.printUsage((Options)options);
                System.exit(1);
            }
            if (System.getProperty("log4j.configuration") == null) {
                Log4jConfigHelper.updateLog4jConfiguration(GobblinTaskRunner.class, "log4j-aws.properties");
            }
            LOGGER.info(JvmUtils.getJvmInputArguments());
            String applicationName = cmd.getOptionValue("app_name");
            String helixInstanceName = cmd.getOptionValue("helix_instance_name");
            String appWorkDir = cmd.getOptionValue("gobblin.aws.work.dir");
            GobblinAWSTaskRunner gobblinTaskRunner = new GobblinAWSTaskRunner(applicationName, helixInstanceName, ConfigFactory.load(), (Optional<Path>)Optional.of((Object)new Path(appWorkDir)));
            gobblinTaskRunner.start();
        }
        catch (ParseException pe) {
            GobblinAWSTaskRunner.printUsage((Options)options);
            System.exit(1);
        }
    }

    private static class ParticipantUserDefinedMessageHandlerFactory
    implements MultiTypeMessageHandlerFactory {
        private ParticipantUserDefinedMessageHandlerFactory() {
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ParticipantUserDefinedMessageHandler(message, context);
        }

        public String getMessageType() {
            return Message.MessageType.USER_DEFINE_MSG.toString();
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private static class ParticipantUserDefinedMessageHandler
        extends MessageHandler {
            public ParticipantUserDefinedMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                LOGGER.warn(String.format("No handling setup for %s message of subtype: %s", Message.MessageType.USER_DEFINE_MSG.toString(), this._message.getMsgSubType()));
                HelixTaskResult helixTaskResult = new HelixTaskResult();
                helixTaskResult.setSuccess(true);
                return helixTaskResult;
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                LOGGER.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }
}

