/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.regions.Region;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.TagDescription;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.aws.AWSClusterSecurityManager;
import org.apache.gobblin.aws.GobblinAWSClusterLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class AWSSdkClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinAWSClusterLauncher.class);
    private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private Supplier<AmazonEC2> amazonEC2Supplier;
    private Supplier<AmazonS3> amazonS3Supplier;
    private Supplier<AmazonAutoScaling> amazonAutoScalingSupplier;

    public AWSSdkClient(final AWSClusterSecurityManager awsClusterSecurityManager, final Region region) {
        this.amazonEC2Supplier = Suppliers.memoize((Supplier)new Supplier<AmazonEC2>(){

            public AmazonEC2 get() {
                AmazonEC2Client amazonEC2 = new AmazonEC2Client(awsClusterSecurityManager.getCredentialsProvider());
                amazonEC2.setRegion(region);
                return amazonEC2;
            }
        });
        this.amazonS3Supplier = Suppliers.memoize((Supplier)new Supplier<AmazonS3>(){

            public AmazonS3 get() {
                AmazonS3Client amazonS3 = new AmazonS3Client(awsClusterSecurityManager.getCredentialsProvider());
                amazonS3.setRegion(region);
                return amazonS3;
            }
        });
        this.amazonAutoScalingSupplier = Suppliers.memoize((Supplier)new Supplier<AmazonAutoScaling>(){

            public AmazonAutoScaling get() {
                AmazonAutoScalingClient amazonAutoScaling = new AmazonAutoScalingClient(awsClusterSecurityManager.getCredentialsProvider());
                amazonAutoScaling.setRegion(region);
                return amazonAutoScaling;
            }
        });
    }

    public void createSecurityGroup(String groupName, String description) {
        AmazonEC2 amazonEC2 = this.getEc2Client();
        try {
            CreateSecurityGroupRequest securityGroupRequest = new CreateSecurityGroupRequest().withGroupName(groupName).withDescription(description);
            amazonEC2.createSecurityGroup(securityGroupRequest);
            LOGGER.info("Created Security Group: " + groupName);
        }
        catch (AmazonServiceException ase) {
            LOGGER.warn("Issue in creating security group", (Throwable)ase);
        }
    }

    public void addPermissionsToSecurityGroup(String groupName, String ipRanges, String ipProtocol, Integer fromPort, Integer toPort) {
        AmazonEC2 amazonEC2 = this.getEc2Client();
        IpPermission ipPermission = new IpPermission().withIpRanges(new String[]{ipRanges}).withIpProtocol(ipProtocol).withFromPort(fromPort).withToPort(toPort);
        AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest = new AuthorizeSecurityGroupIngressRequest().withGroupName(groupName).withIpPermissions(new IpPermission[]{ipPermission});
        amazonEC2.authorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest);
        LOGGER.info("Added permissions: " + ipPermission + " to security group: " + groupName);
    }

    public String createKeyValuePair(String keyName) {
        AmazonEC2 amazonEC2 = this.getEc2Client();
        CreateKeyPairRequest createKeyPairRequest = new CreateKeyPairRequest().withKeyName(keyName);
        CreateKeyPairResult createKeyPairResult = amazonEC2.createKeyPair(createKeyPairRequest);
        KeyPair keyPair = createKeyPairResult.getKeyPair();
        String material = keyPair.getKeyMaterial();
        LOGGER.info("Created key: " + keyName);
        LOGGER.debug("Created material: " + material);
        return material;
    }

    public void createLaunchConfig(String launchConfigName, String imageId, String instanceType, String keyName, String securityGroups, Optional<String> kernelId, Optional<String> ramdiskId, Optional<BlockDeviceMapping> blockDeviceMapping, Optional<String> iamInstanceProfile, Optional<InstanceMonitoring> instanceMonitoring, String userData) {
        AmazonAutoScaling autoScaling = this.getAmazonAutoScalingClient();
        CreateLaunchConfigurationRequest createLaunchConfigurationRequest = new CreateLaunchConfigurationRequest().withLaunchConfigurationName(launchConfigName).withImageId(imageId).withInstanceType(instanceType).withSecurityGroups((Collection)SPLITTER.splitToList((CharSequence)securityGroups)).withKeyName(keyName).withUserData(userData);
        if (kernelId.isPresent()) {
            createLaunchConfigurationRequest = createLaunchConfigurationRequest.withKernelId((String)kernelId.get());
        }
        if (ramdiskId.isPresent()) {
            createLaunchConfigurationRequest = createLaunchConfigurationRequest.withRamdiskId((String)ramdiskId.get());
        }
        if (blockDeviceMapping.isPresent()) {
            createLaunchConfigurationRequest = createLaunchConfigurationRequest.withBlockDeviceMappings(new BlockDeviceMapping[]{(BlockDeviceMapping)blockDeviceMapping.get()});
        }
        if (iamInstanceProfile.isPresent()) {
            createLaunchConfigurationRequest = createLaunchConfigurationRequest.withIamInstanceProfile((String)iamInstanceProfile.get());
        }
        if (instanceMonitoring.isPresent()) {
            createLaunchConfigurationRequest = createLaunchConfigurationRequest.withInstanceMonitoring((InstanceMonitoring)instanceMonitoring.get());
        }
        autoScaling.createLaunchConfiguration(createLaunchConfigurationRequest);
        LOGGER.info("Created Launch Configuration: " + launchConfigName);
    }

    public void deleteLaunchConfiguration(String launchConfigName) {
        AmazonAutoScaling autoScaling = this.getAmazonAutoScalingClient();
        DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest = new DeleteLaunchConfigurationRequest().withLaunchConfigurationName(launchConfigName);
        autoScaling.deleteLaunchConfiguration(deleteLaunchConfigurationRequest);
        LOGGER.info("Deleted Launch Configuration: " + launchConfigName);
    }

    public void createAutoScalingGroup(String groupName, String launchConfig, Integer minSize, Integer maxSize, Integer desiredCapacity, Optional<String> availabilityZones, Optional<Integer> cooldown, Optional<Integer> healthCheckGracePeriod, Optional<String> healthCheckType, Optional<String> loadBalancer, Optional<String> terminationPolicy, List<Tag> tags) {
        AmazonAutoScaling autoScaling = this.getAmazonAutoScalingClient();
        ArrayList tagsWithPropagationSet = Lists.newArrayList();
        for (Tag tag : tags) {
            tagsWithPropagationSet.add(tag.withPropagateAtLaunch(Boolean.valueOf(true)));
        }
        CreateAutoScalingGroupRequest createAutoScalingGroupRequest = new CreateAutoScalingGroupRequest().withAutoScalingGroupName(groupName).withLaunchConfigurationName(launchConfig).withMinSize(minSize).withMaxSize(maxSize).withDesiredCapacity(desiredCapacity).withTags((Collection)tagsWithPropagationSet);
        if (availabilityZones.isPresent()) {
            createAutoScalingGroupRequest = createAutoScalingGroupRequest.withAvailabilityZones((Collection)SPLITTER.splitToList((CharSequence)availabilityZones.get()));
        }
        if (cooldown.isPresent()) {
            createAutoScalingGroupRequest = createAutoScalingGroupRequest.withDefaultCooldown((Integer)cooldown.get());
        }
        if (healthCheckGracePeriod.isPresent()) {
            createAutoScalingGroupRequest = createAutoScalingGroupRequest.withHealthCheckGracePeriod((Integer)healthCheckGracePeriod.get());
        }
        if (healthCheckType.isPresent()) {
            createAutoScalingGroupRequest = createAutoScalingGroupRequest.withHealthCheckType((String)healthCheckType.get());
        }
        if (loadBalancer.isPresent()) {
            createAutoScalingGroupRequest = createAutoScalingGroupRequest.withLoadBalancerNames((Collection)SPLITTER.splitToList((CharSequence)loadBalancer.get()));
        }
        if (terminationPolicy.isPresent()) {
            createAutoScalingGroupRequest = createAutoScalingGroupRequest.withTerminationPolicies((Collection)SPLITTER.splitToList((CharSequence)terminationPolicy.get()));
        }
        autoScaling.createAutoScalingGroup(createAutoScalingGroupRequest);
        LOGGER.info("Created AutoScalingGroup: " + groupName);
    }

    public void deleteAutoScalingGroup(String autoScalingGroupName, boolean shouldForceDelete) {
        AmazonAutoScaling autoScaling = this.getAmazonAutoScalingClient();
        DeleteAutoScalingGroupRequest deleteLaunchConfigurationRequest = new DeleteAutoScalingGroupRequest().withAutoScalingGroupName(autoScalingGroupName).withForceDelete(Boolean.valueOf(shouldForceDelete));
        autoScaling.deleteAutoScalingGroup(deleteLaunchConfigurationRequest);
        LOGGER.info("Deleted AutoScalingGroup: " + autoScalingGroupName);
    }

    public List<AutoScalingGroup> getAutoScalingGroupsWithTag(Tag tag) {
        AmazonAutoScaling autoScaling = this.getAmazonAutoScalingClient();
        DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest = new DescribeAutoScalingGroupsRequest();
        List allAutoScalingGroups = autoScaling.describeAutoScalingGroups(describeAutoScalingGroupsRequest).getAutoScalingGroups();
        ArrayList filteredAutoScalingGroups = Lists.newArrayList();
        for (AutoScalingGroup autoScalingGroup : allAutoScalingGroups) {
            for (TagDescription tagDescription : autoScalingGroup.getTags()) {
                if (!tagDescription.getKey().equalsIgnoreCase(tag.getKey()) || !tagDescription.getValue().equalsIgnoreCase(tag.getValue())) continue;
                filteredAutoScalingGroups.add(autoScalingGroup);
            }
        }
        return filteredAutoScalingGroups;
    }

    public List<Instance> getInstancesForGroup(String groupName, String status) {
        AmazonEC2 amazonEC2 = this.getEc2Client();
        DescribeInstancesResult instancesResult = amazonEC2.describeInstances(new DescribeInstancesRequest().withFilters(new Filter[]{new Filter().withName("tag:aws:autoscaling:groupName").withValues(new String[]{groupName})}));
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (Reservation reservation : instancesResult.getReservations()) {
            for (Instance instance : reservation.getInstances()) {
                if (null == status || null == instance.getState() || status.equals(instance.getState().getName())) {
                    instances.add(instance);
                    LOGGER.info("Found instance: " + instance + " which qualified filter: " + status);
                    continue;
                }
                LOGGER.info("Found instance: " + instance + " but did not qualify for filter: " + status);
            }
        }
        return instances;
    }

    public List<AvailabilityZone> getAvailabilityZones() {
        AmazonEC2 amazonEC2 = this.getEc2Client();
        DescribeAvailabilityZonesResult describeAvailabilityZonesResult = amazonEC2.describeAvailabilityZones();
        List availabilityZones = describeAvailabilityZonesResult.getAvailabilityZones();
        LOGGER.info("Found: " + availabilityZones.size() + " availability zone");
        return availabilityZones;
    }

    public void downloadS3Object(S3ObjectSummary s3ObjectSummary, String targetDirectory) throws IOException {
        AmazonS3 amazonS3 = this.getS3Client();
        GetObjectRequest getObjectRequest = new GetObjectRequest(s3ObjectSummary.getBucketName(), s3ObjectSummary.getKey());
        S3Object s3Object = amazonS3.getObject(getObjectRequest);
        String targetFile = StringUtils.removeEnd((String)targetDirectory, (String)File.separator) + File.separator + s3Object.getKey();
        FileUtils.copyInputStreamToFile((InputStream)s3Object.getObjectContent(), (File)new File(targetFile));
        LOGGER.info("S3 object downloaded to file: " + targetFile);
    }

    public List<S3ObjectSummary> listS3Bucket(String bucketName, String prefix) {
        AmazonS3 amazonS3 = this.getS3Client();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(prefix);
        ObjectListing objectListing = amazonS3.listObjects(listObjectsRequest);
        LOGGER.info("S3 bucket listing for bucket: " + bucketName + " with prefix: " + prefix + " is: " + objectListing);
        return objectListing.getObjectSummaries();
    }

    public AmazonEC2 getEc2Client() {
        return (AmazonEC2)this.amazonEC2Supplier.get();
    }

    public AmazonAutoScaling getAmazonAutoScalingClient() {
        return (AmazonAutoScaling)this.amazonAutoScalingSupplier.get();
    }

    public AmazonS3 getS3Client() {
        return (AmazonS3)this.amazonS3Supplier.get();
    }
}

