/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.typedconfig;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.gobblin.typedconfig.compiletime.EnumOptions;
import org.apache.gobblin.typedconfig.compiletime.IntRange;
import org.apache.gobblin.typedconfig.compiletime.LongRange;
import org.apache.gobblin.typedconfig.compiletime.StringRegex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintUtil {
    private static final Logger log = LoggerFactory.getLogger(ConstraintUtil.class);

    private ConstraintUtil() {
    }

    public static Object constraint(Field field, Object value) {
        Class<?> type = field.getType();
        if (type.isEnum()) {
            return ConstraintUtil.getEnumValue(field, value);
        }
        switch (type.getName()) {
            case "int": 
            case "java.lang.Integer": {
                return ConstraintUtil.getIntValue(field, value);
            }
            case "long": 
            case "java.lang.Long": {
                return ConstraintUtil.getLongValue(field, value);
            }
            case "java.lang.String": {
                return ConstraintUtil.getStringValue(field, value);
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return ConstraintUtil.getBooleanValue(field, value);
            }
            case "java.util.Date": {
                return ConstraintUtil.getDateValue(field, value);
            }
        }
        throw new RuntimeException("not supported the return type: " + type.getName());
    }

    private static Object getIntValue(Field field, Object value) {
        IntRange intRange = field.getAnnotation(IntRange.class);
        if (intRange == null) {
            return value;
        }
        int[] range = intRange.value();
        int intValue = Integer.parseInt(value.toString());
        if (range.length != 2) {
            throw new RuntimeException(String.format("Field [%s]: Long range is invalid.", field.getName()));
        }
        if (intValue >= range[0] && intValue <= range[1]) {
            return value;
        }
        throw new RuntimeException(String.format("Field [%s]: value [%s] is out of range [%s, %s].", field.getName(), value, range[0], range[1]));
    }

    private static Object getLongValue(Field field, Object value) {
        LongRange longRange = field.getAnnotation(LongRange.class);
        long[] range = longRange.value();
        if (range == null) {
            return value;
        }
        long longValue = Long.parseLong(value.toString());
        if (range.length != 2) {
            throw new RuntimeException(String.format("Field [%s]: Long range is invalid.", field.getName()));
        }
        if (longValue > range[0] && longValue < range[1]) {
            return value;
        }
        throw new RuntimeException(String.format("Field [%s]: value [%s] is out of range [%s, %s].", field.getName(), value, range[0], range[1]));
    }

    private static Object getStringValue(Field field, Object value) {
        StringRegex stringRegex = field.getAnnotation(StringRegex.class);
        if (stringRegex == null) {
            return value;
        }
        String regex = stringRegex.value();
        if (regex == null) {
            return value;
        }
        boolean isMatching = value.toString().matches(regex);
        if (isMatching) {
            return value;
        }
        throw new RuntimeException(String.format("[%s] is not matching pattern [%s]", value, regex));
    }

    private static Object getBooleanValue(Field field, Object value) {
        return value;
    }

    private static Object getDateValue(Field field, Object value) {
        return value;
    }

    private static Object getEnumValue(Field field, Object value) {
        EnumOptions enumOptions = field.getAnnotation(EnumOptions.class);
        if (enumOptions == null) {
            return value;
        }
        List<String> options = Arrays.asList(enumOptions.value());
        if (options.indexOf(value) >= 0) {
            return value;
        }
        throw new RuntimeException(String.format("Enum [%s] is not allowed.", value));
    }
}

