/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker.gobblin_scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeInstance;
import org.apache.gobblin.broker.gobblin_scopes.JobScopeInstance;
import org.apache.gobblin.broker.gobblin_scopes.TaskScopeInstance;
import org.apache.gobblin.broker.iface.ScopeInstance;
import org.apache.gobblin.broker.iface.ScopeType;

public enum GobblinScopeTypes implements ScopeType<GobblinScopeTypes>
{
    GLOBAL("global", GobblinScopeInstance.class, new GobblinScopeTypes[0]),
    INSTANCE("instance", GobblinScopeInstance.class, GLOBAL),
    JOB(null, JobScopeInstance.class, INSTANCE),
    CONTAINER("container", GobblinScopeInstance.class, INSTANCE),
    MULTI_TASK_ATTEMPT("multiTask", GobblinScopeInstance.class, JOB, CONTAINER),
    TASK(null, TaskScopeInstance.class, MULTI_TASK_ATTEMPT);

    private static final Set<GobblinScopeTypes> LOCAL_SCOPES;
    private final List<GobblinScopeTypes> parentScopes;
    private final String defaultId;
    private final Class<?> baseInstanceClass;

    private GobblinScopeTypes(String defaultId, Class<?> baseInstanceClass, GobblinScopeTypes ... parentScopes) {
        this.defaultId = defaultId;
        this.parentScopes = Lists.newArrayList((Object[])parentScopes);
        this.baseInstanceClass = baseInstanceClass;
    }

    @Override
    public boolean isLocal() {
        return LOCAL_SCOPES.contains(this);
    }

    @Override
    public Collection<GobblinScopeTypes> parentScopes() {
        return this.parentScopes;
    }

    @Override
    @Nullable
    public ScopeInstance<GobblinScopeTypes> defaultScopeInstance() {
        return this.defaultId == null ? null : new GobblinScopeInstance(this, this.defaultId);
    }

    @Override
    public GobblinScopeTypes rootScope() {
        return GLOBAL;
    }

    Class<?> getBaseInstanceClass() {
        return this.baseInstanceClass;
    }

    static {
        LOCAL_SCOPES = Sets.newHashSet((Object[])new GobblinScopeTypes[]{CONTAINER, TASK, MULTI_TASK_ATTEMPT});
    }
}

