/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.registry;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.osgi.registry.ProviderBundleTrackerCustomizer;
import org.apache.geronimo.osgi.registry.ProviderRegistryImpl;
import org.apache.geronimo.osgi.registry.api.ProviderRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    protected BundleTracker bt;
    protected ServiceTracker lst;
    protected ProviderRegistryImpl registry;
    protected ServiceRegistration registryRegistration;
    protected BundleContext context;
    List<LogService> logServices = new ArrayList<LogService>();

    public synchronized void start(BundleContext context) throws Exception {
        this.context = context;
        this.lst = new LogServiceTracker(context, LogService.class.getName(), null);
        this.lst.open();
        this.registry = new ProviderRegistryImpl(this);
        this.registryRegistration = context.registerService(ProviderRegistry.class.getName(), (Object)this.registry, null);
        ServiceReference ref = context.getServiceReference(ProviderRegistry.class.getName());
        this.bt = new BundleTracker(context, 32, (BundleTrackerCustomizer)new ProviderBundleTrackerCustomizer(this, context.getBundle(), this.registry));
        this.bt.open();
    }

    public synchronized void stop(BundleContext context) throws Exception {
        this.bt.close();
        this.lst.close();
        this.registryRegistration.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(int level, String message) {
        List<LogService> list = this.logServices;
        synchronized (list) {
            for (LogService log : this.logServices) {
                log.log(level, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(int level, String message, Throwable th) {
        List<LogService> list = this.logServices;
        synchronized (list) {
            for (LogService log : this.logServices) {
                log.log(level, message, th);
            }
        }
    }

    private final class LogServiceTracker
    extends ServiceTracker {
        private LogServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
            super(context, clazz, customizer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            Object svc = super.addingService(reference);
            if (svc instanceof LogService) {
                List<LogService> list = Activator.this.logServices;
                synchronized (list) {
                    Activator.this.logServices.add((LogService)svc);
                }
            }
            return svc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference reference, Object service) {
            List<LogService> list = Activator.this.logServices;
            synchronized (list) {
                Activator.this.logServices.remove(service);
            }
            super.removedService(reference, service);
        }
    }
}

