/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.yoko;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.Arrays;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.geronimo.corba.ORBConfiguration;
import org.apache.geronimo.corba.security.config.ConfigUtil;
import org.apache.geronimo.corba.security.config.ssl.SSLCipherSuiteDatabase;
import org.apache.geronimo.corba.security.config.ssl.SSLConfig;
import org.apache.geronimo.corba.security.config.tss.TSSCompoundSecMechListConfig;
import org.apache.geronimo.corba.security.config.tss.TSSConfig;
import org.apache.geronimo.corba.security.config.tss.TSSSSLTransportConfig;
import org.apache.geronimo.corba.security.config.tss.TSSTransportMechConfig;
import org.apache.yoko.orb.OB.IORDump;
import org.apache.yoko.orb.OCI.IIOP.ConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ProfileInfoHolder;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketFactory
implements ConnectionHelper {
    private static final Logger log = LoggerFactory.getLogger(SocketFactory.class);
    private SSLSocketFactory socketFactory = null;
    private SSLServerSocketFactory serverSocketFactory = null;
    private SSLConfig sslConfig = null;
    private String[] cipherSuites;
    private boolean clientAuthSupported;
    private boolean clientAuthRequired;
    int supports = 1;
    int requires = 1;
    private ORB orb;

    public void init(ORB orb, String configName) {
        this.orb = orb;
        this.clientAuthSupported = false;
        this.clientAuthRequired = false;
        ORBConfiguration config = org.apache.geronimo.corba.util.Util.getRegisteredORB((String)configName);
        if (config == null) {
            throw new RuntimeException("Unable to resolve ORB configuration " + configName);
        }
        this.sslConfig = config.getSslConfig();
        TSSConfig tssConfig = config.getTssConfig();
        TSSTransportMechConfig transportMech = tssConfig.getTransport_mech();
        if (transportMech != null && transportMech instanceof TSSSSLTransportConfig) {
            TSSSSLTransportConfig transportConfig = (TSSSSLTransportConfig)transportMech;
            this.supports = transportConfig.getSupports();
            this.requires = transportConfig.getRequires();
        }
        if ((this.supports & 0x40) != 0) {
            this.clientAuthSupported = true;
            if ((this.requires & 0x40) != 0) {
                this.clientAuthRequired = true;
            }
        }
        if ((this.supports & 0x20) != 0) {
            this.clientAuthSupported = true;
            if ((this.requires & 0x20) != 0) {
                this.clientAuthRequired = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating Yoko SocketFactor for GBean " + configName);
            log.debug("   SUPPORTS: " + ConfigUtil.flags((int)this.supports));
            log.debug("   REQUIRES: " + ConfigUtil.flags((int)this.requires));
        }
    }

    public Socket createSocket(IOR ior, Policy[] policies, InetAddress address, int port) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("SocketFactory attempting to create socket for address: " + address + " port: " + port);
            log.debug("Policies: " + Arrays.asList(policies));
            log.debug(IORDump.PrintObjref((ORB)this.orb, (IOR)ior));
        }
        try {
            int i;
            ProfileInfoHolder holder = new ProfileInfoHolder();
            if (Util.extractProfileInfo((IOR)ior, (ProfileInfoHolder)holder)) {
                ProfileInfo profileInfo = holder.value;
                block7: for (i = 0; i < profileInfo.components.length; ++i) {
                    if (profileInfo.components[i].tag != 33) continue;
                    try {
                        TSSCompoundSecMechListConfig config = TSSCompoundSecMechListConfig.decodeIOR((Codec)org.apache.geronimo.corba.util.Util.getCodec(), (TaggedComponent)profileInfo.components[i]);
                        if (log.isDebugEnabled()) {
                            log.debug("looking at tss: " + config);
                        }
                        for (int j = 0; j < config.size(); ++j) {
                            TSSTransportMechConfig transport_mech = config.mechAt(j).getTransport_mech();
                            if (!(transport_mech instanceof TSSSSLTransportConfig)) continue;
                            TSSSSLTransportConfig transportConfig = (TSSSSLTransportConfig)transport_mech;
                            short supports = transportConfig.getSupports();
                            short requires = transportConfig.getRequires();
                            short sslPort = transportConfig.getPort();
                            String sslHost = transportConfig.getHostname();
                            if (log.isDebugEnabled()) {
                                log.debug("IOR to target " + sslHost + ":" + sslPort);
                                log.debug("   SUPPORTS: " + ConfigUtil.flags((int)supports));
                                log.debug("   REQUIRES: " + ConfigUtil.flags((int)requires));
                            }
                            if ((1 & requires) == 1) continue block7;
                            return this.createSSLSocket(sslHost, sslPort, requires, supports);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            String host = address.getHostName();
            for (i = 0; i < ior.profiles.length; ++i) {
                if (ior.profiles[i].tag != 0) continue;
                try {
                    byte[] data = ior.profiles[i].profile_data;
                    ProfileBody_1_0 body = ProfileBody_1_0Helper.extract((Any)org.apache.geronimo.corba.util.Util.getCodec().decode_value(data, ProfileBody_1_0Helper.type()));
                    port = body.port < 0 ? 65535 + body.port + 1 : (int)body.port;
                    log.debug("set port: " + port);
                    continue;
                }
                catch (FormatMismatch e) {
                    log.debug("could not set port: ", (Throwable)e);
                    break;
                }
                catch (TypeMismatch e) {
                    log.debug("could not set port: ", (Throwable)e);
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Created plain endpoint to " + host + ":" + port);
            }
            return new Socket(host, port);
        }
        catch (IOException ex) {
            log.error("Exception creating a client socket to " + address.getHostName() + ":" + port, (Throwable)ex);
            throw ex;
        }
    }

    public Socket createSelfConnection(InetAddress address, int port) throws IOException {
        try {
            if ((1 & this.requires) == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("Created plain endpoint to " + address.getHostName() + ":" + port);
                }
                return new Socket(address, port);
            }
            return this.createSSLSocket(address.getHostName(), port, this.requires, this.supports);
        }
        catch (IOException ex) {
            log.error("Exception creating a client socket to " + address.getHostName() + ":" + port, (Throwable)ex);
            throw ex;
        }
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        try {
            if ((1 & this.requires) == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("Created plain server socket for port " + port);
                }
                return new ServerSocket(port, backlog);
            }
            SSLServerSocket serverSocket = (SSLServerSocket)this.getServerSocketFactory().createServerSocket(port, backlog);
            this.configureServerSocket(serverSocket);
            return serverSocket;
        }
        catch (IOException ex) {
            log.error("Exception creating a server socket for port " + port, (Throwable)ex);
            throw ex;
        }
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address) throws IOException {
        try {
            if ((1 & this.requires) == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("Created plain server socket for port " + port);
                }
                return new ServerSocket(port, backlog, address);
            }
            SSLServerSocket serverSocket = (SSLServerSocket)this.getServerSocketFactory().createServerSocket(port, backlog, address);
            this.configureServerSocket(serverSocket);
            return serverSocket;
        }
        catch (IOException ex) {
            log.error("Exception creating a client socket to " + address.getHostName() + ":" + port, (Throwable)ex);
            throw ex;
        }
    }

    private SSLSocketFactory getSocketFactory() throws IOException {
        if (this.socketFactory == null) {
            if (this.sslConfig == null) {
                this.socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                try {
                    this.socketFactory = this.sslConfig.createSSLFactory(Thread.currentThread().getContextClassLoader());
                }
                catch (Exception e) {
                    log.error("Unable to create client SSL socket factory", (Throwable)e);
                    throw (IOException)new IOException("Unable to create client SSL socket factory: " + e.getMessage()).initCause(e);
                }
            }
        }
        return this.socketFactory;
    }

    private SSLServerSocketFactory getServerSocketFactory() throws IOException {
        if (this.serverSocketFactory == null) {
            if (this.sslConfig == null) {
                this.serverSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            } else {
                try {
                    this.serverSocketFactory = this.sslConfig.createSSLServerFactory(Thread.currentThread().getContextClassLoader());
                }
                catch (Exception e) {
                    log.error("Unable to create server SSL socket factory", (Throwable)e);
                    throw (IOException)new IOException("Unable to create server SSL socket factory: " + e.getMessage()).initCause(e);
                }
            }
            if (this.cipherSuites == null) {
                this.cipherSuites = SSLCipherSuiteDatabase.getCipherSuites((int)this.requires, (int)this.supports, (String[])this.serverSocketFactory.getSupportedCipherSuites());
            }
            this.getSocketFactory();
        }
        return this.serverSocketFactory;
    }

    private void configureServerSocket(SSLServerSocket serverSocket) throws IOException {
        serverSocket.setEnabledCipherSuites(this.cipherSuites);
        if (this.clientAuthRequired) {
            serverSocket.setNeedClientAuth(true);
        } else if (this.clientAuthSupported) {
            serverSocket.setWantClientAuth(true);
        } else {
            serverSocket.setNeedClientAuth(false);
        }
        serverSocket.setSoTimeout(60000);
        if (log.isDebugEnabled()) {
            log.debug("Created SSL server socket on port " + serverSocket.getLocalPort());
            log.debug("    client authentication " + (this.clientAuthSupported ? "SUPPORTED" : "UNSUPPORTED"));
            log.debug("    client authentication " + (this.clientAuthRequired ? "REQUIRED" : "OPTIONAL"));
            log.debug("    cipher suites:");
            for (int i = 0; i < this.cipherSuites.length; ++i) {
                log.debug("    " + this.cipherSuites[i]);
            }
        }
    }

    private Socket createSSLSocket(String host, int port, int requires, int supports) throws IOException {
        SSLSocketFactory factory = this.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(60000);
        String[] iorSuites = SSLCipherSuiteDatabase.getCipherSuites((int)requires, (int)supports, (String[])factory.getSupportedCipherSuites());
        socket.setEnabledCipherSuites(iorSuites);
        if (log.isDebugEnabled()) {
            log.debug("Created SSL socket to " + host + ":" + port);
            log.debug("    cipher suites:");
            for (int i = 0; i < iorSuites.length; ++i) {
                log.debug("    " + iorSuites[i]);
            }
            socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                    Certificate[] certs = handshakeCompletedEvent.getLocalCertificates();
                    if (certs != null) {
                        log.debug("handshake returned local certs count: " + certs.length);
                        for (int i = 0; i < certs.length; ++i) {
                            Certificate cert = certs[i];
                            log.debug("cert: " + cert.toString());
                        }
                    } else {
                        log.debug("handshake returned no local certs");
                    }
                }
            });
        }
        return socket;
    }
}

