/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.util.ArrayList;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.geronimo.validator.ValidationContext;
import org.apache.geronimo.validator.ValidationFailure;
import org.apache.geronimo.webservices.WSDLVisitor;

public class LightWeightMappingValidator
extends WSDLVisitor {
    private ArrayList operationNames;
    private ValidationContext context;
    private static final QName XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");

    public LightWeightMappingValidator(Definition definition) {
        super(definition);
    }

    public ValidationContext validate() {
        if (this.context == null) {
            this.context = new ValidationContext(this.definition.getQName().toString());
            this.walkTree();
        }
        return this.context;
    }

    public boolean isValid() {
        ValidationContext context = this.validate();
        return !context.hasFailures() && !context.hasErrors();
    }

    @Override
    protected void begin() {
        this.operationNames = new ArrayList();
    }

    @Override
    protected void visit(Definition definition) {
        if (definition.getServices().values().size() != 1) {
            this.context.addFailure(new ValidationFailure("A lightweight RPC/Encoded service must contain only one Service"));
        }
    }

    @Override
    protected void visit(Output output) {
        Map outputParts = output.getMessage().getParts();
        if (outputParts.size() != 0 && outputParts.size() != 1) {
            this.context.addFailure(new ValidationFailure("The output message must contain zero or one parts: " + output.getName()));
        }
    }

    @Override
    protected void visit(Operation operation) {
        if (!this.operationNames.add(operation.getName())) {
            this.context.addFailure(new ValidationFailure("No two operations can have the same name: " + operation.getName()));
        }
    }

    @Override
    protected void visit(Fault fault) {
        Part message = fault.getMessage().getPart("message");
        if (message == null) {
            this.context.addFailure(new ValidationFailure("The fault message must contain one part named 'message' : " + fault.getName()));
        } else if (!XSD_STRING.equals(message.getTypeName())) {
            this.context.addFailure(new ValidationFailure("The fault message must contain one part of type 'xsd:string' : " + fault.getName()));
        }
    }

    @Override
    protected void visit(BindingInput bindingInput) {
        SOAPBody body = this.getSOAPBody(bindingInput.getExtensibilityElements());
        String encoding = body.getUse();
        if (encoding == null || !encoding.equals("encoded")) {
            this.context.addFailure(new ValidationFailure("The use attribute of the binding input operation must be 'encoded': " + bindingInput.getName()));
        }
    }

    @Override
    protected void visit(BindingOutput bindingOutput) {
        SOAPBody body = this.getSOAPBody(bindingOutput.getExtensibilityElements());
        String encoding = body.getUse();
        if (encoding == null || !encoding.equals("encoded")) {
            this.context.addFailure(new ValidationFailure("The use attribute of the binding output operation must be 'encoded': " + bindingOutput.getName()));
        }
    }

    @Override
    protected void visit(BindingFault bindingFault) {
        SOAPBody body = this.getSOAPBody(bindingFault.getExtensibilityElements());
        String encoding = body.getUse();
        if (encoding == null || !encoding.equals("encoded")) {
            this.context.addFailure(new ValidationFailure("The use attribute of the binding fault operation must be 'encoded': " + bindingFault.getName()));
        }
    }

    @Override
    protected void visit(Binding binding) {
        SOAPBinding soapBinding = this.getSOAPBinding(binding);
        if (soapBinding == null || soapBinding.getStyle() == null || !soapBinding.getStyle().equals("rpc")) {
            this.context.addFailure(new ValidationFailure("The messaging style of the binding must be rpc: " + binding.getQName()));
        }
    }

    @Override
    protected void visit(Service service) {
        if (service.getPorts().values().size() != 1) {
            this.context.addFailure(new ValidationFailure("A lightweight RPC/Encoded service must contain only one Port"));
        }
    }
}

